/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.util.AnnotationLiteral;
import org.glassfish.cdi.transaction.TransactionScopedCDIEventHelper;
import org.glassfish.cdi.transaction.TransactionScopedCDIEventHelperImpl;
import org.glassfish.cdi.transaction.TransactionScopedCDIEventPayload;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;

public class TransactionScopedCDIUtil {
    public static final String INITIALIZED_EVENT = "INITIALIZED_EVENT";
    public static final String DESTORYED_EVENT = "DESTORYED_EVENT";
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.cdi.LogMessages";
    @LoggerInfo(subsystem="AS-CDI-JTA", description="CDI-JTA", publish=true)
    public static final String CDI_JTA_LOGGER_SUBSYSTEM_NAME = "javax.enterprise.resource.jta";
    private static final Logger _logger = Logger.getLogger("javax.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");

    public static void log(String message) {
        _logger.log(Level.WARNING, message);
    }

    public static Bean createHelperBean(BeanManager beanManager, Class beanClass) {
        BeanWrapper result = null;
        AnnotatedType annotatedType = beanManager.createAnnotatedType(beanClass);
        result = new BeanWrapper(beanClass);
        InjectionTargetFactory factory = beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget injectionTarget = factory.createInjectionTarget((Bean)result);
        result.setInjectionTarget(injectionTarget);
        return result;
    }

    public static void fireEvent(String eventType) {
        BeanManager beanManager = null;
        try {
            beanManager = CDI.current().getBeanManager();
        }
        catch (Exception e) {
            TransactionScopedCDIUtil.log("Can't get instance of BeanManager to process TransactionScoped CDI Event!");
        }
        if (beanManager != null) {
            Set availableBeans = beanManager.getBeans(TransactionScopedCDIEventHelperImpl.class, new Annotation[0]);
            if (null != availableBeans && !availableBeans.isEmpty()) {
                Bean bean = beanManager.resolve(availableBeans);
                TransactionScopedCDIEventHelper eventHelper = (TransactionScopedCDIEventHelper)beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext(null));
                if (eventType.equalsIgnoreCase(INITIALIZED_EVENT)) {
                    eventHelper.fireInitializedEvent(new TransactionScopedCDIEventPayload());
                } else {
                    eventHelper.fireDestroyedEvent(new TransactionScopedCDIEventPayload());
                }
            }
        } else {
            TransactionScopedCDIUtil.log("Can't get instance of BeanManager to process TransactionScoped CDI Event!");
        }
    }

    private static class BeanWrapper
    implements Bean {
        private Class beanClass;
        private InjectionTarget injectionTarget = null;

        public BeanWrapper(Class beanClass) {
            this.beanClass = beanClass;
        }

        private void setInjectionTarget(InjectionTarget injectionTarget) {
            this.injectionTarget = injectionTarget;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionTarget.getInjectionPoints();
        }

        public String getName() {
            return null;
        }

        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            qualifiers.add((Annotation)((Object)new DefaultAnnotationLiteral()));
            qualifiers.add((Annotation)((Object)new AnyAnnotationLiteral()));
            return qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            HashSet<Type> types = new HashSet<Type>();
            types.add(this.beanClass);
            types.add((Type)((Object)Object.class));
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }

        public Object create(CreationalContext ctx) {
            Object instance = this.injectionTarget.produce(ctx);
            this.injectionTarget.inject(instance, ctx);
            this.injectionTarget.postConstruct(instance);
            return instance;
        }

        public void destroy(Object instance, CreationalContext ctx) {
            this.injectionTarget.preDestroy(instance);
            this.injectionTarget.dispose(instance);
            ctx.release();
        }

        public static class AnyAnnotationLiteral
        extends AnnotationLiteral<Any> {
            private static final long serialVersionUID = -4700109250603725375L;
        }

        public static class DefaultAnnotationLiteral
        extends AnnotationLiteral<Default> {
            private static final long serialVersionUID = -9065007202240742004L;
        }
    }
}

