/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.meta;

import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataUserException;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class JDOMetaDataProperties {
    private static final char FIELD_DELIMITER = '#';
    private static final String PROPERTY_DELIMITERS = " \t,;";
    private static final char PROPERTY_ASSIGNER = ':';
    private static final String PROPERTY_ACCESS_MODIFIER = "access";
    private static final String PROPERTY_JDO_MODIFIER = "jdo";
    private static final String PROPERTY_SUPER_CLASSNAME = "super";
    private static final String PROPERTY_OID_CLASSNAME = "oid";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_ANNOTATION_TYPE = "annotation";
    private static final String ACCESS_PRIVATE = "private";
    private static final String ACCESS_PACKAGE_LOCAL = "package";
    private static final String ACCESS_PROTECTED = "protected";
    private static final String ACCESS_PUBLIC = "public";
    private static final String JDO_TRANSIENT = "transient";
    private static final String JDO_PERSISTENT = "persistent";
    private static final String JDO_TRANSACTIONAL = "transactional";
    private static final String ANNOTATION_TYPE_PK = "pk";
    private static final String ANNOTATION_TYPE_DFG = "dfg";
    private static final String ANNOTATION_TYPE_MEDIATED = "mediated";
    private Properties properties;
    private final Map cachedJDOClasses = new HashMap();
    private static final JDOClass NULL = new JDOClass(null);
    private final List tmpTokens = new ArrayList();

    public JDOMetaDataProperties(Properties props) {
        this.properties = props;
    }

    public final JDOClass getJDOClass(String classname) throws JDOMetaDataUserException {
        JDOClass clazz = (JDOClass)this.cachedJDOClasses.get(classname = JDOMetaDataProperties.toCanonicalClassName(classname));
        if (clazz == NULL) {
            return null;
        }
        if (clazz != null) {
            return clazz;
        }
        String s = this.properties.getProperty(classname);
        if (s == null) {
            this.cachedJDOClasses.put(classname, NULL);
            return null;
        }
        clazz = this.parseJDOClass(classname, s);
        this.parseJDOFields(clazz);
        this.validateDependencies(clazz);
        this.cachedJDOClasses.put(clazz.getName(), clazz);
        return clazz;
    }

    public final JDOField getJDOField(String fieldname, String classname) throws JDOMetaDataUserException {
        JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getField(fieldname) : null;
    }

    public final String[] getKnownClassNames() {
        HashSet<String> classnames = new HashSet<String>();
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.indexOf(35) >= 0) continue;
            classnames.add(JDOMetaDataProperties.fromCanonicalClassName(name));
        }
        return classnames.toArray(new String[classnames.size()]);
    }

    private static final String toCanonicalClassName(String classname) {
        return classname.replace('/', '.');
    }

    private static final String fromCanonicalClassName(String classname) {
        return classname.replace('.', '/');
    }

    private final JDOClass parseJDOClass(String classname, String attributes) throws JDOMetaDataUserException {
        List props = this.parseProperties(attributes);
        for (int i = 0; i < props.size(); ++i) {
            Property prop = (Property)props.get(i);
            JDOMetaDataProperties.validateClassProperty(prop, classname);
        }
        JDOMetaDataProperties.checkForDuplicateProperties(props, classname);
        JDOClass clazz = new JDOClass(classname);
        for (int i = 0; i < props.size(); ++i) {
            Property prop = (Property)props.get(i);
            if (prop.name.equals(PROPERTY_ACCESS_MODIFIER)) {
                clazz.modifiers = JDOMetaDataProperties.getModifiers(prop.value);
                continue;
            }
            if (prop.name.equals(PROPERTY_JDO_MODIFIER)) {
                clazz.isPersistent = prop.value.equals(JDO_PERSISTENT);
                continue;
            }
            if (prop.name.equals(PROPERTY_SUPER_CLASSNAME)) {
                clazz.setSuperClassName(prop.value);
                continue;
            }
            if (!prop.name.equals(PROPERTY_OID_CLASSNAME)) continue;
            clazz.setOidClassName(prop.value);
        }
        return clazz;
    }

    private static final void validateClassProperty(Property prop, String classname) throws JDOMetaDataUserException {
        String value = prop.value;
        if (prop.name == null) {
            prop.name = value.equals(ACCESS_PUBLIC) || value.equals(ACCESS_PROTECTED) || value.equals(ACCESS_PACKAGE_LOCAL) || value.equals(ACCESS_PRIVATE) ? PROPERTY_ACCESS_MODIFIER : (value.equals(JDO_PERSISTENT) || value.equals(JDO_TRANSIENT) ? PROPERTY_JDO_MODIFIER : PROPERTY_SUPER_CLASSNAME);
        } else {
            String name = prop.name;
            JDOMetaDataProperties.checkPropertyName(prop.name, new String[]{PROPERTY_OID_CLASSNAME, PROPERTY_ACCESS_MODIFIER, PROPERTY_JDO_MODIFIER, PROPERTY_SUPER_CLASSNAME}, classname);
            JDOMetaDataProperties.checkPropertyValue(prop, new String[]{ACCESS_PUBLIC, ACCESS_PROTECTED, ACCESS_PACKAGE_LOCAL, ACCESS_PRIVATE}, PROPERTY_ACCESS_MODIFIER, classname);
            JDOMetaDataProperties.checkPropertyValue(prop, new String[]{JDO_TRANSIENT, JDO_PERSISTENT}, PROPERTY_JDO_MODIFIER, classname);
        }
    }

    private final void parseJDOFields(JDOClass clazz) throws JDOMetaDataUserException {
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(clazz.getName() + '#')) continue;
            String fieldname = name.substring(name.indexOf(35) + 1, name.length());
            JDOMetaDataProperties.validateFieldName(fieldname, clazz.getName());
            clazz.addField(this.parseJDOField(this.properties.getProperty(name), fieldname, clazz));
        }
        clazz.sortFields();
    }

    private final JDOField parseJDOField(String attributes, String fieldname, JDOClass clazz) throws JDOMetaDataUserException {
        List props = this.parseProperties(attributes);
        for (int i = 0; i < props.size(); ++i) {
            Property prop = (Property)props.get(i);
            this.validateFieldProperty(prop, fieldname, clazz.getName());
        }
        JDOMetaDataProperties.checkForDuplicateProperties(props, clazz.getName() + '#' + fieldname);
        JDOField field = new JDOField(fieldname);
        for (int i = 0; i < props.size(); ++i) {
            Property prop = (Property)props.get(i);
            if (prop.name.equals(PROPERTY_ACCESS_MODIFIER)) {
                field.modifiers = JDOMetaDataProperties.getModifiers(prop.value);
                continue;
            }
            if (prop.name.equals(PROPERTY_JDO_MODIFIER)) {
                field.jdoModifier = prop.value;
                continue;
            }
            if (prop.name.equals(PROPERTY_TYPE)) {
                field.setType(prop.value);
                continue;
            }
            if (!prop.name.equals(PROPERTY_ANNOTATION_TYPE)) continue;
            field.annotationType = prop.value;
        }
        return field;
    }

    private final void validateFieldProperty(Property prop, String fieldname, String classname) throws JDOMetaDataUserException {
        String value = prop.value;
        if (prop.name == null) {
            prop.name = value.equals(ACCESS_PUBLIC) || value.equals(ACCESS_PROTECTED) || value.equals(ACCESS_PACKAGE_LOCAL) || value.equals(ACCESS_PRIVATE) ? PROPERTY_ACCESS_MODIFIER : (value.equals(JDO_PERSISTENT) || value.equals(JDO_TRANSIENT) || value.equals(JDO_TRANSACTIONAL) ? PROPERTY_JDO_MODIFIER : (value.equals(ANNOTATION_TYPE_PK) || value.equals(ANNOTATION_TYPE_DFG) || value.equals(ANNOTATION_TYPE_MEDIATED) ? PROPERTY_ANNOTATION_TYPE : PROPERTY_TYPE));
        } else {
            String entry = classname + '#' + fieldname;
            JDOMetaDataProperties.checkPropertyName(prop.name, new String[]{PROPERTY_ACCESS_MODIFIER, PROPERTY_JDO_MODIFIER, PROPERTY_TYPE, PROPERTY_ANNOTATION_TYPE}, entry);
            JDOMetaDataProperties.checkPropertyValue(prop, new String[]{ACCESS_PUBLIC, ACCESS_PROTECTED, ACCESS_PACKAGE_LOCAL, ACCESS_PRIVATE}, PROPERTY_ACCESS_MODIFIER, entry);
            JDOMetaDataProperties.checkPropertyValue(prop, new String[]{JDO_PERSISTENT, JDO_TRANSIENT, JDO_TRANSACTIONAL}, PROPERTY_JDO_MODIFIER, entry);
            JDOMetaDataProperties.checkPropertyValue(prop, new String[]{ANNOTATION_TYPE_PK, ANNOTATION_TYPE_DFG, ANNOTATION_TYPE_MEDIATED}, PROPERTY_ANNOTATION_TYPE, entry);
        }
    }

    private final void validateDependencies(JDOClass clazz) throws JDOMetaDataUserException {
        for (int i = clazz.fields.size() - 1; i >= 0; --i) {
            JDOField field = (JDOField)clazz.fields.get(i);
            if (field.jdoModifier == null) {
                field.jdoModifier = clazz.isPersistent() ? JDO_PERSISTENT : JDO_TRANSIENT;
            } else if (clazz.isTransient()) {
                if (field.isPersistent()) {
                    throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: A non-persistent class cannot have a persistent field (class ''{0}'' with field ''{1})''.", new String[]{clazz.getName(), field.getName()}));
                }
                if (field.isTransactional()) {
                    throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: A non-persistent class cannot have a transactional field (class ''{0}'' with field ''{1})''.", new String[]{clazz.getName(), field.getName()}));
                }
            }
            if (field.isAnnotated() && clazz.isTransient()) {
                throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: A non-persistent class cannot have an annotated field (''{1}'' of class ''{0}'') can''t have a fetch group.", new String[]{clazz.getName(), field.getName()}));
            }
            if (!field.isPersistent() && field.isAnnotated()) {
                field.annotationType = ANNOTATION_TYPE_MEDIATED;
            }
            if (field.isAnnotated() || !clazz.isPersistent()) continue;
            field.annotationType = ANNOTATION_TYPE_MEDIATED;
        }
    }

    private static final void validateFieldName(String fieldname, String classname) throws JDOMetaDataUserException {
        if (fieldname.length() == 0) {
            throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The class ''{0}'' may not have an empty fieldname.", new String[]{classname}));
        }
        if (!Character.isJavaIdentifierStart(fieldname.charAt(0))) {
            throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The field name ''{1}'' of class ''{0}'' is not valid.", new String[]{classname, fieldname}));
        }
        for (int i = fieldname.length() - 1; i >= 0; --i) {
            char c = fieldname.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The field name ''{1}'' of class ''{0}'' is not valid.", new String[]{classname, fieldname}));
        }
    }

    private static final void checkForDuplicateProperties(List props, String entry) throws JDOMetaDataUserException {
        for (int i = 0; i < props.size(); ++i) {
            for (int j = i + 1; j < props.size(); ++j) {
                Property p1 = (Property)props.get(i);
                Property p2 = (Property)props.get(j);
                if (!p1.name.equals(p2.name) || p1.value.equals(p2.value)) continue;
                throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The property ''{1}'' for the entry ''{0}'' entered twice with values: ''{2}'' and ''{3}''.", new String[]{entry, p1.name, p1.value, p2.value}));
            }
        }
    }

    private static final void checkPropertyName(String name, String[] validnames, String entry) throws JDOMetaDataUserException {
        for (int i = 0; i < validnames.length; ++i) {
            if (!name.equals(validnames[i])) continue;
            return;
        }
        throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: Invalid property name for entry ''{0}'': ''{1}''.", new String[]{entry, name}));
    }

    private static final void checkPropertyValue(Property prop, String[] validvalues, String name, String entry) throws JDOMetaDataUserException {
        if (!prop.name.equals(name)) {
            return;
        }
        for (int i = 0; i < validvalues.length; ++i) {
            if (!prop.value.equals(validvalues[i])) continue;
            return;
        }
        throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: Invalid value for property ''{1}'' of entry ''{0}'': ''{2}''.", new String[]{entry, name, prop.value}));
    }

    static final String getErrorMsg(String msg, String[] params) {
        return MessageFormat.format(msg, params);
    }

    final List parseProperties(String attributes) throws JDOMetaDataUserException {
        this.tmpTokens.clear();
        StringTokenizer t = new StringTokenizer(attributes, PROPERTY_DELIMITERS);
        while (t.hasMoreTokens()) {
            this.tmpTokens.add(this.parseProperty(t.nextToken()));
        }
        return this.tmpTokens;
    }

    private final Property parseProperty(String attribute) throws JDOMetaDataUserException {
        Property prop = new Property();
        int idx = attribute.indexOf(58);
        if (idx < 0) {
            prop.value = attribute;
        } else {
            prop.name = attribute.substring(0, idx);
            prop.value = attribute.substring(idx + 1, attribute.length());
            if (prop.name.length() == 0 || prop.value.length() == 0) {
                throw new JDOMetaDataUserException(JDOMetaDataProperties.getErrorMsg("Error Parsing meta data properties: The property name and value may not be empty if a '':'' is specified: ''{0}''.", new String[]{attribute}));
            }
        }
        return prop;
    }

    private static final int getModifiers(String modifier) {
        if (modifier.equals(ACCESS_PUBLIC)) {
            return 1;
        }
        if (modifier.equals(ACCESS_PRIVATE)) {
            return 2;
        }
        if (modifier.equals(ACCESS_PROTECTED)) {
            return 4;
        }
        return 0;
    }

    static final class JDOField {
        private String name;
        private String type = null;
        private int modifiers = 2;
        private String jdoModifier = null;
        private String annotationType = null;

        JDOField(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        public final void setType(String type) {
            this.type = JDOMetaDataProperties.fromCanonicalClassName(type);
        }

        public final String getType() {
            return this.type;
        }

        public final int getModifiers() {
            return this.modifiers;
        }

        public final boolean isAnnotated() {
            return this.annotationType != null;
        }

        public final boolean isPk() {
            return this.annotationType != null && this.annotationType.equals(JDOMetaDataProperties.ANNOTATION_TYPE_PK);
        }

        public final boolean isInDefaultFetchGroup() {
            return this.annotationType != null && this.annotationType.equals(JDOMetaDataProperties.ANNOTATION_TYPE_DFG);
        }

        public boolean isKnownTransient() {
            return this.jdoModifier != null && this.jdoModifier.equals(JDOMetaDataProperties.JDO_TRANSIENT);
        }

        public final boolean isPersistent() {
            return this.jdoModifier != null && this.jdoModifier.equals(JDOMetaDataProperties.JDO_PERSISTENT);
        }

        public final boolean isTransactional() {
            return this.jdoModifier != null && this.jdoModifier.equals(JDOMetaDataProperties.JDO_TRANSACTIONAL);
        }

        public final boolean isManaged() {
            return this.isPersistent() || this.isTransactional();
        }

        public final String toString() {
            return "<name:" + this.name + ',' + JDOMetaDataProperties.PROPERTY_TYPE + ':' + this.type + ',' + JDOMetaDataProperties.PROPERTY_ACCESS_MODIFIER + ':' + Modifier.toString(this.modifiers) + ',' + JDOMetaDataProperties.PROPERTY_JDO_MODIFIER + ':' + this.jdoModifier + ',' + JDOMetaDataProperties.PROPERTY_ANNOTATION_TYPE + ':' + this.annotationType + '>';
        }
    }

    static final class JDOClass {
        private String name;
        private String superClassName = null;
        private String oidClassName = null;
        private int modifiers = 1;
        private boolean isPersistent = true;
        private final List fields = new ArrayList();
        private String[] managedFieldNames = null;
        private String[] fieldNames = null;

        JDOClass(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        public final int getModifiers() {
            return this.modifiers;
        }

        private final void setSuperClassName(String classname) {
            this.superClassName = JDOMetaDataProperties.fromCanonicalClassName(classname);
        }

        public final String getSuperClassName() {
            return this.superClassName;
        }

        public void setOidClassName(String classname) {
            this.oidClassName = JDOMetaDataProperties.fromCanonicalClassName(classname);
        }

        public String getOidClassName() {
            return this.oidClassName;
        }

        public final boolean isPersistent() {
            return this.isPersistent;
        }

        public final boolean isTransient() {
            return !this.isPersistent();
        }

        private final void addField(JDOField field) {
            this.fields.add(field);
        }

        public final JDOField getField(String name) {
            int idx = this.getIndexOfField(name);
            return idx > -1 ? (JDOField)this.fields.get(idx) : null;
        }

        public final int getIndexOfField(String name) {
            for (int i = 0; i < this.fields.size(); ++i) {
                JDOField field = (JDOField)this.fields.get(i);
                if (!field.getName().equals(name)) continue;
                return i;
            }
            return -1;
        }

        public final String[] getFields() {
            if (this.fieldNames == null) {
                int n = this.fields.size();
                String[] fields = new String[n];
                for (int i = 0; i < n; ++i) {
                    fields[i] = ((JDOField)this.fields.get(i)).getName();
                }
                this.fieldNames = fields;
            }
            return this.fieldNames;
        }

        private final void sortFields() {
            Collections.sort(this.fields, new Comparator(){

                public final int compare(Object f1, Object f2) {
                    JDOField field1 = (JDOField)f1;
                    JDOField field2 = (JDOField)f2;
                    if (!field1.isManaged() || !field2.isManaged()) {
                        return field1.isManaged() ? -1 : 1;
                    }
                    return field1.getName().compareTo(field2.getName());
                }
            });
        }

        public final String[] getManagedFieldNames() {
            if (this.managedFieldNames == null) {
                int n = this.fields.size();
                ArrayList<String> tmp = new ArrayList<String>(n);
                for (int i = 0; i < n; ++i) {
                    JDOField field = (JDOField)this.fields.get(i);
                    if (!field.isManaged()) continue;
                    tmp.add(field.getName());
                }
                this.managedFieldNames = tmp.toArray(new String[tmp.size()]);
            }
            return this.managedFieldNames;
        }

        public final String toString() {
            return "<super:" + this.superClassName + ',' + JDOMetaDataProperties.PROPERTY_ACCESS_MODIFIER + ':' + Modifier.toString(this.modifiers) + ',' + JDOMetaDataProperties.PROPERTY_JDO_MODIFIER + ':' + this.isPersistent + ',' + "fields:" + this.fields + '>';
        }
    }

    private static interface IErrorMessages {
        public static final String PREFIX = "Error Parsing meta data properties: ";
        public static final String ERR_EMPTY_FIELDNAME = "Error Parsing meta data properties: The class ''{0}'' may not have an empty fieldname.";
        public static final String ERR_INVALID_FIELDNAME = "Error Parsing meta data properties: The field name ''{1}'' of class ''{0}'' is not valid.";
        public static final String ERR_EMPTY_PROPERTY_NAME_OR_VALUE = "Error Parsing meta data properties: The property name and value may not be empty if a '':'' is specified: ''{0}''.";
        public static final String ERR_INVALID_PROPERTY_NAME = "Error Parsing meta data properties: Invalid property name for entry ''{0}'': ''{1}''.";
        public static final String ERR_INVALID_PROPERTY_VALUE = "Error Parsing meta data properties: Invalid value for property ''{1}'' of entry ''{0}'': ''{2}''.";
        public static final String ERR_DUPLICATE_PROPERTY_NAME = "Error Parsing meta data properties: The property ''{1}'' for the entry ''{0}'' entered twice with values: ''{2}'' and ''{3}''.";
        public static final String ERR_TRANSIENT_CLASS_WITH_PERSISTENT_FIELD = "Error Parsing meta data properties: A non-persistent class cannot have a persistent field (class ''{0}'' with field ''{1})''.";
        public static final String ERR_TRANSIENT_CLASS_WITH_TRANSACTIONAL_FIELD = "Error Parsing meta data properties: A non-persistent class cannot have a transactional field (class ''{0}'' with field ''{1})''.";
        public static final String ERR_TRANSIENT_CLASS_WITH_ANNOTATED_FIELD = "Error Parsing meta data properties: A non-persistent class cannot have an annotated field (''{1}'' of class ''{0}'') can''t have a fetch group.";
        public static final String ERR_NON_PERSISTENT_ANNOTATED_FIELD = "Error Parsing meta data properties: A non-persistent field (''{1}'' of class ''{0}'') can''t be a annotated.";
    }

    private static final class Property {
        String name = null;
        String value = null;

        private Property() {
        }

        public final String toString() {
            return '<' + this.name + ':' + this.value + '>';
        }
    }
}

