/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.List;
import java.util.Map;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="export")
@PerLookup
public class ExportCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ExportCommand.class);
    @Param(name="environment-variable", primary=true, optional=true, multiple=true)
    private List<String> vars;

    @Override
    public int executeCommand() throws CommandException, CommandValidationException {
        int ret = 0;
        if (this.vars == null || this.vars.size() == 0) {
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                logger.info(e.getKey() + " = " + ExportCommand.quote(e.getValue()));
            }
        } else {
            for (String arg : this.vars) {
                String value;
                String name;
                int eq = arg.indexOf(61);
                if (eq < 0) {
                    name = arg;
                    value = null;
                } else {
                    name = arg.substring(0, eq);
                    value = arg.substring(eq + 1);
                }
                if (!name.startsWith(Environment.getPrefix())) {
                    logger.info(strings.get("badEnvVarSet", new Object[]{name, Environment.getPrefix()}));
                    ret = -1;
                    continue;
                }
                if (value == null) {
                    String v = this.env.get(name);
                    if (v == null) continue;
                    logger.info(name + " = " + v);
                    continue;
                }
                this.env.put(name, value);
            }
        }
        return ret;
    }
}

