/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.util.Iterator;
import java.util.Objects;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.hpack.BinaryRepresentationWriter;
import org.glassfish.grizzly.http2.hpack.HeaderTable;
import org.glassfish.grizzly.http2.hpack.SizeUpdateWriter;

final class BulkSizeUpdateWriter
implements BinaryRepresentationWriter {
    private final SizeUpdateWriter writer = new SizeUpdateWriter();
    private Iterator<Integer> maxSizes;
    private boolean writing;
    private boolean configured;

    BulkSizeUpdateWriter() {
    }

    BulkSizeUpdateWriter maxHeaderTableSizes(Iterable<Integer> sizes) {
        if (this.configured) {
            throw new IllegalStateException("Already configured");
        }
        Objects.requireNonNull(sizes, "sizes");
        this.maxSizes = sizes.iterator();
        this.configured = true;
        return this;
    }

    @Override
    public boolean write(HeaderTable table, Buffer destination) {
        if (!this.configured) {
            throw new IllegalStateException("Configure first");
        }
        while (true) {
            if (this.writing) {
                if (!this.writer.write(table, destination)) {
                    return false;
                }
                this.writing = false;
                continue;
            }
            if (!this.maxSizes.hasNext()) break;
            this.writing = true;
            this.writer.reset();
            this.writer.maxHeaderTableSize(this.maxSizes.next());
        }
        this.configured = false;
        return true;
    }

    @Override
    public BulkSizeUpdateWriter reset() {
        this.maxSizes = null;
        this.writing = false;
        this.configured = false;
        return this;
    }
}

