/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CommandXMLResultParser {
    static DFDeploymentStatus parse(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory pf = SAXParserFactory.newInstance();
        pf.setValidating(true);
        pf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser parser = pf.newSAXParser();
        DFDeploymentStatus topStatus = null;
        ResultHandler rh = new ResultHandler();
        parser.parse(is, (DefaultHandler)rh);
        topStatus = rh.getTopStatus();
        return topStatus;
    }

    private static DFDeploymentStatus.Status exitCodeToStatus(String exitCodeText) {
        return DFDeploymentStatus.Status.valueOf(exitCodeText);
    }

    private static class ResultHandler
    extends DefaultHandler {
        private DFDeploymentStatus topStatus;
        private DFDeploymentStatus currentLevel;

        private ResultHandler() {
        }

        private String attrToText(Attributes attrs, String attrName) {
            return attrs.getValue(attrName);
        }

        private DFDeploymentStatus getTopStatus() {
            return this.topStatus;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("action-report")) {
                if (this.topStatus == null) {
                    this.currentLevel = this.topStatus = new DFDeploymentStatus();
                } else {
                    this.addLevel();
                }
                this.currentLevel.setStageStatus(CommandXMLResultParser.exitCodeToStatus(this.attrToText(attributes, "exit-code")));
                this.currentLevel.setStageDescription(this.attrToText(attributes, "description"));
                String failureCause = this.attrToText(attributes, "failure-cause");
                if (failureCause != null) {
                    this.currentLevel.setStageStatusMessage(failureCause);
                }
            } else if (qName.equals("message-part")) {
                this.addLevel();
                String msg = this.attrToText(attributes, "message");
                if (msg != null) {
                    String origMsg = this.currentLevel.getStageStatusMessage();
                    msg = this.currentLevel.getStageStatusMessage() + (origMsg != null && origMsg.length() > 0 ? " " : "") + msg;
                    this.currentLevel.setStageStatusMessage(msg);
                }
            } else if (qName.equals("property")) {
                this.currentLevel.addProperty(this.attrToText(attributes, "name"), this.attrToText(attributes, "value"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("action-report")) {
                this.popLevel();
            } else if (qName.equals("message-part")) {
                this.popLevel();
            }
        }

        private void addLevel() {
            DFDeploymentStatus newLevel = new DFDeploymentStatus();
            this.currentLevel.addSubStage(newLevel);
            this.currentLevel = newLevel;
        }

        private void popLevel() {
            this.currentLevel = this.currentLevel.getParent();
        }
    }
}

