/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.config.DigesterFactory;
import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.RenderKitBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.config.rules.FacesConfigRuleSet;
import com.sun.faces.generate.JspTLD12Generator;
import com.sun.faces.generate.JspTLD21Generator;
import com.sun.faces.generate.JspTLDGenerator;
import com.sun.faces.generate.PropertyManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.xml.sax.InputSource;

public class GeneratorUtil {
    private static final String PREFIX = "javax.faces.";
    private static Map<String, String> UNWRAPPERS = new HashMap<String, String>();
    private static Map<String, String> WRAPPERS;

    public static String convertToPrimitive(String objectType) {
        return UNWRAPPERS.get(objectType);
    }

    public static String convertToObject(String primitiveType) {
        return WRAPPERS.get(primitiveType);
    }

    public static JspTLDGenerator getTldGenerator(PropertyManager propManager) {
        String version = propManager.getProperty("jsp.version");
        if ("1.2".equals(version)) {
            return new JspTLD12Generator(propManager);
        }
        if ("2.1".equals(version)) {
            return new JspTLD21Generator(propManager);
        }
        throw new IllegalArgumentException("Unsupported version of JSP '" + version + '\'');
    }

    public static String stripJavaxFacesPrefix(String identifier) {
        if (identifier.startsWith(PREFIX)) {
            return identifier.substring(PREFIX.length());
        }
        return identifier;
    }

    public static String makeTagClassName(String componentFamily, String rendererType) {
        if (componentFamily == null) {
            return null;
        }
        String tagClassName = componentFamily;
        if (rendererType != null && !componentFamily.equals(rendererType)) {
            tagClassName = tagClassName + rendererType;
        }
        return tagClassName + "Tag";
    }

    public static Map<String, ComponentBean> getComponentFamilyComponentMap(FacesConfigBean configBean) {
        TreeMap<String, ComponentBean> result = new TreeMap<String, ComponentBean>();
        for (ComponentBean component : configBean.getComponents()) {
            if (component == null) {
                throw new IllegalStateException("No Components Found");
            }
            if (component.isIgnore() || component.getBaseComponentType() != null) continue;
            String componentFamily = component.getComponentFamily();
            result.put(componentFamily, component);
        }
        return result;
    }

    public static Map<String, ArrayList<RendererBean>> getComponentFamilyRendererMap(FacesConfigBean configBean, String renderKitId) {
        RenderKitBean renderKit = configBean.getRenderKit(renderKitId);
        if (renderKit == null) {
            throw new IllegalArgumentException("No RenderKit for id '" + renderKitId + '\'');
        }
        RendererBean[] renderers = renderKit.getRenderers();
        if (renderers == null) {
            throw new IllegalStateException("No Renderers for RenderKit id\"" + renderKitId + '\"');
        }
        TreeMap<String, ArrayList<RendererBean>> result = new TreeMap<String, ArrayList<RendererBean>>();
        for (RendererBean renderer : renderers) {
            if (renderer == null) {
                throw new IllegalStateException("no Renderer");
            }
            String componentFamily = renderer.getComponentFamily();
            ArrayList<RendererBean> list = result.get(componentFamily);
            if (list == null) {
                list = new ArrayList();
                list.add(renderer);
                result.put(componentFamily, list);
                continue;
            }
            list.add(renderer);
        }
        return result;
    }

    public static String getFirstDivFromString(String toParse, int[] out) {
        int divEnd;
        String result = null;
        if (null == toParse) {
            return result;
        }
        int divStart = toParse.indexOf("<div");
        if (-1 != divStart && -1 != (divEnd = toParse.indexOf(">", divStart))) {
            result = toParse.substring(divStart, divEnd + 1);
        }
        if (null != out && 0 < out.length) {
            out[0] = divStart;
        }
        return result;
    }

    public static String getFirstSpanFromString(String toParse, int[] out) {
        int spanEnd;
        String result = null;
        if (null == toParse) {
            return result;
        }
        int spanStart = toParse.indexOf("<span");
        if (-1 != spanStart && -1 != (spanEnd = toParse.indexOf(">", spanStart))) {
            result = toParse.substring(spanStart, spanEnd + 1);
        }
        if (null != out && 0 < out.length) {
            out[0] = spanStart;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FacesConfigBean getConfigBean(String facesConfig) throws Exception {
        FacesConfigBean fcb = null;
        InputStream stream = null;
        try {
            File file = new File(facesConfig);
            stream = new BufferedInputStream(new FileInputStream(file));
            InputSource source = new InputSource(file.toURL().toString());
            source.setByteStream(stream);
            fcb = (FacesConfigBean)GeneratorUtil.createDigester(true, false, true).parse(source);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
                stream = null;
            }
        }
        return fcb;
    }

    private static Digester createDigester(boolean design, boolean generate, boolean runtime) {
        Digester digester = DigesterFactory.newInstance(true).createDigester();
        digester.addRuleSet((RuleSet)new FacesConfigRuleSet(design, generate, runtime));
        return digester;
    }

    static {
        UNWRAPPERS.put("boolean", "booleanValue");
        UNWRAPPERS.put("byte", "byteValue");
        UNWRAPPERS.put("char", "charValue");
        UNWRAPPERS.put("double", "doubleValue");
        UNWRAPPERS.put("float", "floatValue");
        UNWRAPPERS.put("int", "intValue");
        UNWRAPPERS.put("long", "longValue");
        UNWRAPPERS.put("short", "shortValue");
        WRAPPERS = new HashMap<String, String>();
        WRAPPERS.put("boolean", "java.lang.Boolean");
        WRAPPERS.put("byte", "java.lang.Byte");
        WRAPPERS.put("char", "java.lang.Character");
        WRAPPERS.put("double", "java.lang.Double");
        WRAPPERS.put("float", "java.lang.Float");
        WRAPPERS.put("int", "java.lang.Integer");
        WRAPPERS.put("long", "java.lang.Long");
        WRAPPERS.put("short", "java.lang.Short");
    }
}

