/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.osgi.loader;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ClassCodeBaseHandler;
import com.sun.corba.ee.spi.trace.Osgi;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.pfl.basic.func.UnaryFunction;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

@Osgi
public class OSGIListener
implements BundleActivator,
SynchronousBundleListener {
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static final String ORB_PROVIDER_KEY = "ORB-Class-Provider";
    private static PackageAdmin pkgAdmin;
    private static Map<String, Bundle> classNameMap;
    private static Map<String, Bundle> packageNameMap;
    private static UnaryFunction<String, Class<?>> classNameResolver;
    private static ClassCodeBaseHandler ccbHandler;

    private static void setPackageAdmin(PackageAdmin pa) {
        pkgAdmin = pa;
    }

    private static Dictionary secureGetHeaders(final Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getHeaders();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Dictionary>(){

            @Override
            public Dictionary run() {
                return bundle.getHeaders();
            }
        });
    }

    private static Class<?> secureLoadClass(final Bundle bundle, final String className) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return bundle.loadClass(className);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return bundle.loadClass(className);
                }
            });
        }
        catch (PrivilegedActionException exc) {
            throw (ClassNotFoundException)exc.getException();
        }
    }

    private static String getBundleEventType(int type) {
        if (type == 1) {
            return "INSTALLED";
        }
        if (type == 512) {
            return "LAZY_ACTIVATION";
        }
        if (type == 32) {
            return "RESOLVED";
        }
        if (type == 2) {
            return "STARTED";
        }
        if (type == 128) {
            return "STARTING";
        }
        if (type == 4) {
            return "STOPPED";
        }
        if (type == 256) {
            return "STOPPING";
        }
        if (type == 16) {
            return "UNINSTALLED";
        }
        if (type == 64) {
            return "UNRESOLVED";
        }
        if (type == 8) {
            return "UPDATED";
        }
        return "ILLEGAL-EVENT-TYPE";
    }

    @InfoMethod
    private void classNotFoundInBundle(String arg) {
    }

    @InfoMethod
    private void foundClassInBundle(String arg, String name) {
    }

    @Osgi
    public static UnaryFunction<String, Class<?>> classNameResolver() {
        return classNameResolver;
    }

    @Osgi
    public static ClassCodeBaseHandler classCodeBaseHandler() {
        return ccbHandler;
    }

    @InfoMethod
    private void insertOrbProvider(String cname, String bname) {
    }

    @InfoMethod
    private void insertBundlePackage(String pname, String bname) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Osgi
    private void insertClasses(Bundle bundle) {
        lock.writeLock().lock();
        try {
            ExportedPackage[] epkgs;
            String orbProvider;
            Dictionary dict = OSGIListener.secureGetHeaders(bundle);
            String name = bundle.getSymbolicName();
            if (dict != null && (orbProvider = (String)dict.get(ORB_PROVIDER_KEY)) != null) {
                for (String string : orbProvider.split(",")) {
                    String className = string.trim();
                    classNameMap.put(className, bundle);
                    this.insertOrbProvider(className, name);
                }
            }
            if (pkgAdmin != null && (epkgs = pkgAdmin.getExportedPackages(bundle)) != null) {
                for (ExportedPackage exportedPackage : epkgs) {
                    String pname = exportedPackage.getName();
                    packageNameMap.put(pname, bundle);
                    this.insertBundlePackage(pname, bundle.getSymbolicName());
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @InfoMethod
    private void removeOrbProvider(String cname, String bname) {
    }

    @InfoMethod
    private void removeBundlePackage(String pname, String bname) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Osgi
    private void removeClasses(Bundle bundle) {
        lock.writeLock().lock();
        try {
            ExportedPackage[] epkgs;
            String orbProvider;
            Dictionary dict = OSGIListener.secureGetHeaders(bundle);
            String name = bundle.getSymbolicName();
            if (dict != null && (orbProvider = (String)dict.get(ORB_PROVIDER_KEY)) != null) {
                for (String string : orbProvider.split(",")) {
                    classNameMap.remove(string);
                    this.removeOrbProvider(string, name);
                }
            }
            if (pkgAdmin != null && (epkgs = pkgAdmin.getExportedPackages(bundle)) != null) {
                for (ExportedPackage exportedPackage : epkgs) {
                    String pname = exportedPackage.getName();
                    packageNameMap.remove(pname);
                    this.removeBundlePackage(pname, bundle.getSymbolicName());
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Osgi
    private static Bundle getBundleForClass(String className) {
        lock.readLock().lock();
        try {
            int index;
            Bundle result = classNameMap.get(className);
            if (result == null && (index = className.lastIndexOf(46)) > 0) {
                String packageName = className.substring(0, index);
                result = packageNameMap.get(packageName);
            }
            Bundle bundle = result;
            return bundle;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @InfoMethod
    private void probeBundlesForProviders() {
    }

    @Osgi
    public void start(BundleContext context) {
        ServiceReference sref = context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        OSGIListener.setPackageAdmin((PackageAdmin)context.getService(sref));
        if (pkgAdmin == null) {
            wrapper.packageAdminServiceNotAvailable();
        }
        context.addBundleListener((BundleListener)this);
        this.probeBundlesForProviders();
        for (Bundle bundle : context.getBundles()) {
            this.insertClasses(bundle);
        }
    }

    @Osgi
    public void stop(BundleContext context) {
        Bundle myBundle = context.getBundle();
        this.removeClasses(myBundle);
    }

    @InfoMethod
    private void receivedBundleEvent(String type, String name) {
    }

    @Osgi
    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Bundle bundle = event.getBundle();
        String name = bundle.getSymbolicName();
        this.receivedBundleEvent(OSGIListener.getBundleEventType(type), name);
        if (type == 2) {
            this.insertClasses(bundle);
        } else if (type == 1) {
            this.removeClasses(bundle);
        }
    }

    static {
        classNameMap = new ConcurrentHashMap<String, Bundle>();
        packageNameMap = new ConcurrentHashMap<String, Bundle>();
        classNameResolver = new ClassNameResolverImpl();
        ccbHandler = new ClassCodeBaseHandlerImpl();
    }

    @Osgi
    private static class ClassNameResolverImpl
    implements UnaryFunction<String, Class<?>> {
        private ClassNameResolverImpl() {
        }

        @InfoMethod
        private void classNotFoundInBundle(String arg) {
        }

        @InfoMethod
        private void foundClassInBundle(String arg, String name) {
        }

        @Osgi
        public Class<?> evaluate(String arg) {
            Bundle bundle = OSGIListener.getBundleForClass(arg);
            if (bundle == null) {
                this.classNotFoundInBundle(arg);
                return null;
            }
            this.foundClassInBundle(arg, bundle.getSymbolicName());
            try {
                return OSGIListener.secureLoadClass(bundle, arg);
            }
            catch (ClassNotFoundException ex) {
                throw wrapper.bundleCouldNotLoadClass(ex, arg, bundle.getSymbolicName());
            }
        }

        public String toString() {
            return "OSGiClassNameResolver";
        }
    }

    @Osgi
    private static class ClassCodeBaseHandlerImpl
    implements ClassCodeBaseHandler {
        private static final String PREFIX = "osgi://";

        private ClassCodeBaseHandlerImpl() {
        }

        @InfoMethod
        private void classNotFoundInBundle(String name) {
        }

        @InfoMethod
        private void foundClassInBundleVersion(Class<?> cls, String name, String version) {
        }

        @Override
        @Osgi
        public String getCodeBase(Class<?> cls) {
            String hver;
            if (cls == null) {
                return null;
            }
            if (pkgAdmin == null) {
                return null;
            }
            Bundle bundle = pkgAdmin.getBundle(cls);
            if (bundle == null) {
                this.classNotFoundInBundle(cls.getName());
                return null;
            }
            String name = bundle.getSymbolicName();
            Dictionary headers = OSGIListener.secureGetHeaders(bundle);
            String version = "0.0.0";
            if (headers != null && (hver = (String)headers.get("Bundle-Version")) != null) {
                version = hver;
            }
            this.foundClassInBundleVersion(cls, name, version);
            return PREFIX + name + "/" + version;
        }

        @InfoMethod
        private void couldNotLoadClassInBundle(ClassNotFoundException exc, String className, String bname) {
        }

        @InfoMethod
        private void foundClassInBundleVersion(String cname, String bname, String version) {
        }

        @InfoMethod
        private void classNotFoundInBundleVersion(String cname, String bname, String version) {
        }

        @Override
        @Osgi
        public Class<?> loadClass(String codebase, String className) {
            String rest;
            int index;
            if (codebase == null) {
                Bundle bundle = OSGIListener.getBundleForClass(className);
                if (bundle != null) {
                    try {
                        return OSGIListener.secureLoadClass(bundle, className);
                    }
                    catch (ClassNotFoundException exc) {
                        this.couldNotLoadClassInBundle(exc, className, bundle.getSymbolicName());
                        return null;
                    }
                }
                return null;
            }
            if (codebase.startsWith(PREFIX) && (index = (rest = codebase.substring(PREFIX.length())).indexOf(47)) > 0) {
                Bundle[] defBundles;
                String name = rest.substring(0, index);
                String version = rest.substring(index + 1);
                if (pkgAdmin != null && (defBundles = pkgAdmin.getBundles(name, version)) != null) {
                    try {
                        this.foundClassInBundleVersion(className, name, version);
                        return OSGIListener.secureLoadClass(defBundles[0], className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.classNotFoundInBundleVersion(className, name, version);
                    }
                }
            }
            return null;
        }
    }
}

