/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Tab;
import com.sun.webui.jsf.component.TabSet;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.MethodExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;

public final class TabSetRenderer
extends AbstractRenderer {
    private static final String SKIP_ANCHOR_NAME = "tabSetSkipAnchor";
    private static final String SELECTED_TAB_ANCHOR_NAME = "selectedTabAnchor";
    private static final String EMPTY_STR = "";
    private static final String SPACE = " ";

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        TabSet tabSet = (TabSet)component;
        String selectedTabId = tabSet.getSelected();
        Theme theme = ThemeUtilities.getTheme(context);
        String lite = theme.getStyleClass("TABGROUPBOX");
        if (selectedTabId == null) {
            if (tabSet.isMini() && tabSet.isLite()) {
                writer.startElement("div", (UIComponent)tabSet);
                writer.writeAttribute("class", (Object)lite, null);
                writer.endElement("div");
            }
            writer.endElement("div");
            return;
        }
        Tab selectedTab = tabSet.findChildTab(selectedTabId);
        if (selectedTab == null) {
            if (tabSet.isMini() && tabSet.isLite()) {
                writer.startElement("div", (UIComponent)tabSet);
                writer.writeAttribute("class", (Object)lite, null);
                writer.endElement("div");
            }
            writer.endElement("div");
            return;
        }
        if (tabSet.isMini() && tabSet.isLite()) {
            writer.startElement("div", (UIComponent)tabSet);
            writer.writeAttribute("class", (Object)lite, null);
        }
        while (selectedTab.getTabChildCount() > 0) {
            selectedTabId = selectedTab.getSelectedChildId();
            if (selectedTabId == null) {
                selectedTabId = ((Tab)selectedTab.getChildren().get(0)).getId();
            }
            selectedTab = (Tab)selectedTab.findComponent(selectedTabId);
        }
        int numKids = selectedTab.getChildCount();
        if (numKids > 0) {
            UIComponent facet = tabSet.getFacet("contentHeader");
            if (facet != null) {
                RenderingUtilities.renderComponent(facet, context);
            }
            List kids = selectedTab.getChildren();
            for (int i = 0; i < numKids; ++i) {
                UIComponent kid = (UIComponent)kids.get(i);
                RenderingUtilities.renderComponent(kid, context);
            }
            facet = tabSet.getFacet("contentFooter");
            if (facet != null) {
                RenderingUtilities.renderComponent(facet, context);
            }
        }
        if (tabSet.isMini() && tabSet.isLite()) {
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        List level3Tabs;
        TabSet tabSet = (TabSet)component;
        ResponseWriter writer = context.getResponseWriter();
        Theme theme = ThemeUtilities.getTheme(context);
        List level1 = tabSet.getChildren();
        if (level1.size() < 1) {
            if (LogUtil.infoEnabled()) {
                LogUtil.info(TabSetRenderer.class, "WEBUI0005", new String[]{tabSet.getId()});
            }
            return;
        }
        this.startTabSetDiv(context, writer, tabSet, theme);
        this.renderSkipLink(context, tabSet, theme);
        List level2Tabs = this.renderLevel(context, tabSet, writer, 1, tabSet.getChildren());
        if (level2Tabs != null && (level3Tabs = this.renderLevel(context, tabSet, writer, 2, level2Tabs)) != null) {
            this.renderLevel(context, tabSet, writer, 3, level3Tabs);
        }
        RenderingUtilities.renderAnchor(SKIP_ANCHOR_NAME, (UIComponent)tabSet, context);
    }

    private void startTabSetDiv(FacesContext context, ResponseWriter writer, TabSet tabSet, Theme theme) throws IOException {
        String style = tabSet.getStyle();
        String styleClass = tabSet.getStyleClass();
        String lite = theme.getStyleClass("TABGROUP");
        if (tabSet.isMini() && tabSet.isLite()) {
            styleClass = styleClass != null ? styleClass.concat(SPACE).concat(lite) : lite;
        }
        if (!tabSet.isVisible()) {
            String hiddenStyle = theme.getStyleClass("HIDDEN");
            styleClass = styleClass == null ? hiddenStyle : styleClass.concat(SPACE).concat(hiddenStyle);
        }
        writer.startElement("div", (UIComponent)tabSet);
        writer.writeAttribute("id", (Object)tabSet.getClientId(context), "id");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
    }

    private String[] getStyles(TabSet tabSet, Theme theme, int level) {
        String divStyle = EMPTY_STR;
        String tableStyle = EMPTY_STR;
        String linkStyle = EMPTY_STR;
        String selectedTdStyle = EMPTY_STR;
        String selectedTextStyle = EMPTY_STR;
        switch (level) {
            case 1: {
                if (tabSet.isMini()) {
                    divStyle = theme.getStyleClass("MINI_TAB_DIV");
                    tableStyle = theme.getStyleClass("MINI_TAB_TABLE");
                    linkStyle = theme.getStyleClass("MINI_TAB_LINK");
                    selectedTdStyle = theme.getStyleClass("MINI_TAB_TABLE_SELECTED_TD");
                    selectedTextStyle = theme.getStyleClass("MINI_TAB_SELECTED_TEXT");
                    break;
                }
                divStyle = theme.getStyleClass("TAB1_DIV");
                tableStyle = theme.getStyleClass("TAB1_TABLE_NEW");
                linkStyle = theme.getStyleClass("TAB1_LINK");
                selectedTdStyle = theme.getStyleClass("TAB1_TABLE_SELECTED_TD");
                selectedTextStyle = theme.getStyleClass("TAB1_SELECTED_TEXT_NEW");
                break;
            }
            case 2: {
                divStyle = theme.getStyleClass("TAB2_DIV");
                tableStyle = theme.getStyleClass("TAB2_TABLE_NEW");
                linkStyle = theme.getStyleClass("TAB2_LINK");
                selectedTdStyle = theme.getStyleClass("TAB2_TABLE_SELECTED_TD");
                selectedTextStyle = theme.getStyleClass("TAB2_SELECTED_TEXT");
                break;
            }
            case 3: {
                divStyle = theme.getStyleClass("TAB3_DIV");
                tableStyle = theme.getStyleClass("TAB3_TABLE_NEW");
                linkStyle = theme.getStyleClass("TAB3_LINK");
                selectedTdStyle = theme.getStyleClass("TAB3_TABLE_SELECTED_TD");
                selectedTextStyle = theme.getStyleClass("TAB3_SELECTED_TEXT");
                break;
            }
        }
        String[] styles = new String[]{divStyle, tableStyle, linkStyle, selectedTdStyle, selectedTextStyle};
        return styles;
    }

    private void renderSkipLink(FacesContext context, TabSet tabSet, Theme theme) throws IOException {
        Object obj;
        Tab selectedTab = tabSet.findChildTab(tabSet.getSelected());
        Object[] args = new String[]{EMPTY_STR};
        if (selectedTab != null && (obj = selectedTab.getText()) != null) {
            args[0] = ConversionUtilities.convertValueToString((UIComponent)selectedTab, obj);
        }
        String toolTip = theme.getMessage("tab.skipTagAltText", args);
        String styleClass = theme.getStyleClass("SKIP_MEDIUM_GREY1");
        RenderingUtilities.renderSkipLink(SKIP_ANCHOR_NAME, styleClass, null, toolTip, null, (UIComponent)tabSet, context);
    }

    private void layoutLevel(ResponseWriter writer, TabSet tabSet, String[] styles) throws IOException {
        writer.startElement("div", (UIComponent)tabSet);
        writer.writeAttribute("class", (Object)styles[0], null);
        writer.startElement("table", (UIComponent)tabSet);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("class", (Object)styles[1], null);
        writer.writeAttribute("title", (Object)EMPTY_STR, null);
        writer.startElement("tr", (UIComponent)tabSet);
    }

    protected List renderLevel(FacesContext context, TabSet tabSet, ResponseWriter writer, int level, List currentLevelTabs) throws IOException {
        int numTabs = currentLevelTabs.size();
        if (numTabs == 0) {
            return null;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = this.getStyles(tabSet, theme, level);
        String hidden = theme.getStyleClass("HIDDEN");
        String selectedTabId = tabSet.getSelected();
        Tab currentLevelSelection = null;
        boolean levelHasSelection = false;
        for (int i = 0; i < numTabs; ++i) {
            try {
                currentLevelSelection = (Tab)currentLevelTabs.get(i);
            }
            catch (ClassCastException cce) {
                continue;
            }
            if (!this.isSelected(currentLevelSelection, selectedTabId)) continue;
            levelHasSelection = true;
            break;
        }
        if (!levelHasSelection) {
            try {
                selectedTabId = ((Tab)currentLevelTabs.get(0)).getId();
                tabSet.setSelected(selectedTabId);
            }
            catch (ClassCastException i) {
                // empty catch block
            }
        }
        if (currentLevelSelection != null && currentLevelSelection.getTabChildCount() > 0) {
            switch (level) {
                case 1: {
                    styles[1] = theme.getStyleClass("TAB1_TABLE2_NEW");
                    break;
                }
                case 2: {
                    styles[1] = theme.getStyleClass("TAB2_TABLE3_NEW");
                    break;
                }
            }
        }
        this.layoutLevel(writer, tabSet, styles);
        MethodExpression actionListenerExpression = tabSet.getActionListenerExpression();
        List nextLevelToRender = null;
        for (int i = 0; i < numTabs; ++i) {
            Tab tab;
            try {
                tab = (Tab)currentLevelTabs.get(i);
            }
            catch (ClassCastException cce) {
                continue;
            }
            if (!tab.isRendered()) continue;
            writer.startElement("td", (UIComponent)tabSet);
            String newSelectedClass = styles[3];
            String newNonSelectedClass = null;
            if (!tab.isVisible()) {
                newSelectedClass = newSelectedClass.concat(SPACE).concat(hidden);
                newNonSelectedClass = hidden;
            }
            if (selectedTabId != null && this.isSelected(tab, selectedTabId)) {
                nextLevelToRender = this.renderSelectedTab(context, writer, theme, tabSet, tab, styles, newSelectedClass);
            } else {
                tab.setStyleClass(styles[2]);
                RenderingUtilities.renderComponent((UIComponent)tab, context);
            }
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        return nextLevelToRender;
    }

    private List renderSelectedTab(FacesContext context, ResponseWriter writer, Theme theme, TabSet tabSet, Tab tab, String[] styles, String selectedClass) throws IOException {
        UIComponent parent = tab.getParent();
        if (parent != null && parent instanceof Tab) {
            if (tabSet.isLastSelectedChildSaved()) {
                ((Tab)parent).setSelectedChildId(tab.getId());
            } else {
                ((Tab)parent).setSelectedChildId(null);
            }
        }
        String label = EMPTY_STR;
        Object obj = tab.getText();
        if (obj != null) {
            label = ConversionUtilities.convertValueToString((UIComponent)tab, obj);
        }
        String selectionDivClass = styles[4];
        if (label.length() < 6) {
            String padClass = theme.getStyleClass("TAB_PADDING");
            selectionDivClass = selectionDivClass.concat(SPACE).concat(padClass);
        }
        writer.writeAttribute("class", (Object)selectedClass, null);
        writer.startElement("div", (UIComponent)tab);
        writer.writeAttribute("class", (Object)selectionDivClass, null);
        String titleString = theme.getMessage("tabSet.selectedTab", new Object[]{label});
        writer.writeAttribute("title", (Object)titleString, null);
        writer.startElement("a", (UIComponent)tab);
        writer.writeAttribute("id", (Object)tab.getClientId(context), "id");
        writer.writeAttribute("name", (Object)SELECTED_TAB_ANCHOR_NAME, "name");
        writer.endElement("a");
        writer.write(label);
        writer.endElement("div");
        if (tab.getTabChildCount() == 0) {
            return null;
        }
        return tab.getTabChildren();
    }

    protected boolean isSelected(Tab tab, String selectedTabId) {
        if (selectedTabId == null) {
            return false;
        }
        if (selectedTabId.equals(tab.getId())) {
            return true;
        }
        if (tab.getTabChildCount() == 0) {
            return false;
        }
        for (Tab child : tab.getTabChildren()) {
            if (!this.isSelected(child, selectedTabId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
    }
}

