/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component.factory.sun;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.factory.sun.TableRowGroupFactory;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutStaticText;
import com.sun.jsftemplating.layout.event.CreateChildEvent;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.List;

public class DynamicColumnTableRowGroupFactory
extends TableRowGroupFactory {
    public static final String COLUMN_TYPE = "sun:tableColumn";
    public static final String COLUMN_VALUE_KEY = "columnValue";
    public static final String COLUMN_SEPERATOR = "col";
    public static final String CHILD_SUFFIX = "child";
    public static final int COLUMN_LEN = "column".length();

    @Override
    public UIComponent create(FacesContext ctx, LayoutComponent desc, UIComponent parent) {
        UIComponent comp = super.create(ctx, desc, parent);
        String id = comp.getId();
        ArrayList<String> colAttKeys = new ArrayList<String>();
        for (String key : desc.getOptions().keySet()) {
            if (!key.startsWith("column")) continue;
            colAttKeys.add(key);
        }
        if (colAttKeys.size() == 0) {
            return comp;
        }
        List<Object> values = this.getColumnPropertyValues(ctx, desc, (String)colAttKeys.get(0), parent);
        int size = values.size();
        ArrayList<LayoutComponent> columns = new ArrayList<LayoutComponent>(size);
        ComponentType colType = LayoutDefinitionManager.getGlobalComponentType(ctx, COLUMN_TYPE);
        for (int idx = 0; idx < size; ++idx) {
            LayoutComponent column = new LayoutComponent(desc, id + COLUMN_SEPERATOR + idx, colType);
            columns.add(column);
        }
        for (String key : colAttKeys) {
            if (key.equals(COLUMN_VALUE_KEY)) continue;
            values = this.getColumnPropertyValues(ctx, desc, key, parent);
            int idx = 0;
            for (Object entry : values) {
                ((LayoutComponent)columns.get(idx++)).addOption(this.getColumnKey(key), entry);
            }
        }
        UIComponent columnComp = null;
        String value = null;
        Object eventVal = null;
        values = this.getColumnPropertyValues(ctx, desc, COLUMN_VALUE_KEY, parent);
        int idx = 0;
        ComponentUtil compUtil = ComponentUtil.getInstance(ctx);
        for (LayoutComponent columnDesc : columns) {
            columnComp = compUtil.createChildComponent(ctx, columnDesc, comp);
            eventVal = desc.dispatchHandlers(ctx, "createChild", new CreateChildEvent(columnComp, value = "" + values.get(idx++)));
            if (eventVal != null && eventVal instanceof UIComponent) {
                columnComp.getChildren().add((UIComponent)eventVal);
                continue;
            }
            compUtil.createChildComponent(ctx, new LayoutStaticText((LayoutElement)columnDesc, columnDesc.getUnevaluatedId() + CHILD_SUFFIX, value), columnComp);
        }
        return comp;
    }

    private List<Object> getColumnPropertyValues(FacesContext ctx, LayoutComponent parentDesc, String propertyName, UIComponent parent) {
        Object val = parentDesc.getEvaluatedOption(ctx, propertyName, parent);
        if (val == null) {
            throw new IllegalArgumentException("DynamicColumnTableRowGroupFactory requires a valid '" + propertyName + "' attribute, however one was not supplied!");
        }
        if (val instanceof String && ComponentUtil.getInstance(ctx).isValueReference((String)val)) {
            ValueExpression ve = ctx.getApplication().getExpressionFactory().createValueExpression(ctx.getELContext(), (String)val, Object.class);
            val = ve.getValue(ctx.getELContext());
        }
        if (!(val instanceof List)) {
            throw new IllegalArgumentException("DynamicColumnTableRowGroupFactory requires all 'column*' properties to resolve to an instance of a List. '" + propertyName + "' is a '" + val.getClass().getName() + "'!");
        }
        return (List)val;
    }

    private String getColumnKey(String key) {
        return key.substring(COLUMN_LEN, COLUMN_LEN + 1).toLowerCase() + key.substring(COLUMN_LEN + 1);
    }

    @Override
    protected void setOption(FacesContext ctx, UIComponent comp, LayoutComponent desc, String key, Object value) {
        if (key.startsWith("column")) {
            return;
        }
        super.setOption(ctx, comp, desc, key, value);
    }
}

