/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.interceptor;

import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.ha.cache.api.AbstractCommandInterceptor;
import org.glassfish.shoal.ha.cache.api.DataStoreContext;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.interceptor.CommandCollector;
import org.glassfish.shoal.ha.cache.interceptor.ReplicationCommandTransmitterWithList;
import org.glassfish.shoal.ha.cache.interceptor.ReplicationCommandTransmitterWithMap;
import org.glassfish.shoal.ha.cache.store.backing.commands.NoOpCommand;

public class ReplicationCommandTransmitterManager<K, V>
extends AbstractCommandInterceptor<K, V> {
    private static final Logger _logger = Logger.getLogger("org.glassfish.shoal.ha.cache.command");
    private ConcurrentHashMap<String, CommandCollector<K, V>> transmitters = new ConcurrentHashMap();
    private CommandCollector<K, V> broadcastTransmitter;

    @Override
    public void initialize(DataStoreContext<K, V> dsc) {
        super.initialize(dsc);
        this.broadcastTransmitter = new ReplicationCommandTransmitterWithList();
        this.broadcastTransmitter.initialize(null, dsc);
        _logger.log(Level.FINE, "ReplicationCommandTransmitterManager(" + dsc.getServiceName() + ") instantiated with: " + dsc.isUseMapToCacheCommands() + " : " + dsc.isSafeToDelayCaptureState());
    }

    @Override
    public void onTransmit(Command<K, V> cmd, String initiator) throws DataStoreException {
        switch (cmd.getOpcode()) {
            case 1: {
                super.onTransmit(cmd, initiator);
                break;
            }
            default: {
                String target = cmd.getTargetName();
                if (target != null) {
                    CommandCollector<K, V> rft = this.transmitters.get(target);
                    if (rft == null) {
                        rft = this.dsc.isUseMapToCacheCommands() ? new ReplicationCommandTransmitterWithMap() : new ReplicationCommandTransmitterWithList();
                        rft.initialize(target, this.getDataStoreContext());
                        CommandCollector<K, V> oldRCT = this.transmitters.putIfAbsent(target, rft);
                        if (oldRCT != null) {
                            rft = oldRCT;
                        }
                    }
                    if (cmd.getOpcode() == 36) {
                        rft.removeCommand(cmd);
                        break;
                    }
                    rft.addCommand(cmd);
                    break;
                }
                this.broadcastTransmitter.addCommand(cmd);
            }
        }
    }

    @Override
    public void close() {
        for (CommandCollector<K, V> cc : this.transmitters.values()) {
            cc.close();
        }
        try {
            this.broadcastTransmitter.addCommand(new NoOpCommand());
        }
        catch (DataStoreException dataStoreException) {
            // empty catch block
        }
        this.broadcastTransmitter.close();
    }
}

