/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.LogControl;
import com.sun.jts.CosTransactions.LogControlDescriptor;
import com.sun.jts.CosTransactions.LogCursor;
import com.sun.jts.CosTransactions.LogException;
import com.sun.jts.CosTransactions.LogExtent;
import com.sun.jts.CosTransactions.LogFileHandle;
import com.sun.jts.CosTransactions.LogLSN;
import com.sun.jts.CosTransactions.LogRecordEnding;
import com.sun.jts.CosTransactions.LogRecordHeader;
import com.sun.jts.CosTransactions.LogRestartDescriptor;
import com.sun.jts.CosTransactions.LogUpcallTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

class LogHandle {
    private static final StringManager sm = StringManager.getManager(LogHandle.class);
    static final int BUFFER = 0;
    static final int FORCE = 1;
    static final int TAIL_NOT_INCLUSIVE = 0;
    static final int TAIL_INCLUSIVE = 1;
    static final int START_CKPT = 0;
    static final int INDV_CKPT = 1;
    static final int END_CKPT = 2;
    static final int NEW_JRNL = 3;
    static final int RECORD_TYPE_MAX = 65535;
    static final int MARKER = 65535;
    static final int LINK = 65536;
    static final int MAX_NUMBER_EXTENTS = -1;
    static final int CONTROL_FORCE_INTERVAL = 100;
    static final int MAX_EXTENT_SIZE = 65536;
    static final int CUSHION_SIZE = 65536;
    static final int NAME_LENGTH = 8;
    static final int MAX_NAMES = 4096;
    static final int FILENAME_PREFIX_LEN = 5;
    static final int EXTENT_TABLE_SIZE = 16;
    static final int CALLBACK_REASON_SOS = 1;
    static final int RESTART_OFFSET_1 = 4096;
    static final int RESTART_OFFSET_2 = 20480;
    static final int MAX_RECORD_SIZE = 65456;
    static final int MAX_RESTART_SIZE = 16360;
    static final int CONTROL_FILE_SIZE = 36864;
    static final int ALLOCATE_SIZE = 65536;
    LogHandle blockValid = null;
    int restartDataLength = 0;
    int recordsWritten = 0;
    int chunkRemaining = 0;
    int activeRestartVersion = 0;
    LogUpcallTarget upcallTarget = null;
    ArrayList cursors = null;
    boolean cushionExists = false;
    boolean upcallInProgress = false;
    Hashtable extentTable = null;
    String logFileName = null;
    LogFileHandle logFileHandle = null;
    LogControlDescriptor logControlDescriptor = null;
    LogControl logControl = null;

    LogHandle(LogControl control, String logName, LogFileHandle controlFH, LogUpcallTarget upcall) throws LogException {
        this.logFileName = logName;
        this.upcallTarget = upcall;
        this.logControl = control;
        this.logFileHandle = controlFH;
        this.blockValid = this;
        this.logControlDescriptor = new LogControlDescriptor();
        this.cursors = new ArrayList();
        this.extentTable = new Hashtable(16);
    }

    synchronized LogLSN writeRecord(byte[] record, int recordType, int writeMode) throws LogException {
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControl.logReadOnly) {
            throw new LogException(null, 27, 3);
        }
        if (recordType > 65535) {
            throw new LogException(null, 24, 5);
        }
        if (writeMode != 1 && writeMode != 0) {
            throw new LogException(null, 25, 6);
        }
        int recordSize = record.length + 32 + 8;
        if (recordSize > 65456) {
            throw new LogException(null, 10, 7);
        }
        int remainingSpace = 65536 - (this.logControlDescriptor.nextLSN.offset + 64 + 8);
        LogExtent logEDP = this.positionFilePointer(this.logControlDescriptor.nextLSN, 0, 2);
        if (remainingSpace < recordSize) {
            LogRecordHeader link = new LogRecordHeader();
            int nextExtent = this.logControlDescriptor.headLSN.extent + 1;
            if (nextExtent < 0) {
                throw new LogException(null, 7, 8);
            }
            if (this.extentTable.containsKey(LogExtent.modExtent(nextExtent))) {
                throw new LogException(null, 7, 9);
            }
            link.recordType = 65536;
            link.previousLSN = new LogLSN(this.logControlDescriptor.headLSN);
            link.currentLSN = new LogLSN(this.logControlDescriptor.nextLSN);
            link.nextLSN = new LogLSN(nextExtent, 0);
            LogExtent nextEDP = this.positionFilePointer(link.nextLSN, 0, 2);
            byte[] linkBytes = new byte[32];
            link.toBytes(linkBytes, 0);
            int bytesWritten = 0;
            try {
                bytesWritten = logEDP.fileHandle.fileWrite(linkBytes);
            }
            catch (LogException le) {
                this.extentTable.remove(this.logControlDescriptor.headLSN.extent);
                nextEDP.doFinalize();
                throw new LogException(7, 10, sm.getString("jts.log_add_link_failed"), le);
            }
            logEDP.writtenSinceLastForce = true;
            logEDP.cursorPosition += bytesWritten;
            this.logControlDescriptor.headLSN.copy(link.currentLSN);
            this.logControlDescriptor.nextLSN.copy(link.nextLSN);
            logEDP = nextEDP;
            this.chunkRemaining = 0;
        }
        LogLSN nextFree = new LogLSN(this.logControlDescriptor.nextLSN.extent, this.logControlDescriptor.nextLSN.offset + recordSize);
        LogRecordHeader logRH = new LogRecordHeader();
        logRH.recordType = recordType;
        logRH.recordLength = record.length;
        logRH.nextLSN = nextFree;
        logRH.previousLSN = new LogLSN(this.logControlDescriptor.headLSN);
        logRH.currentLSN = new LogLSN(this.logControlDescriptor.nextLSN);
        LogRecordEnding logRE = new LogRecordEnding();
        logRE.currentLSN = logRH.currentLSN;
        byte[] writeBytes = new byte[32 + record.length + 8];
        logRH.toBytes(writeBytes, 0);
        System.arraycopy(record, 0, writeBytes, 32, record.length);
        logRE.toBytes(writeBytes, 32 + record.length);
        boolean cushionFreed = false;
        if (this.chunkRemaining > recordSize) {
            this.chunkRemaining -= recordSize;
        } else {
            int grabSize = this.chunkRemaining + 65536;
            if (grabSize + this.logControlDescriptor.nextLSN.offset > 65536) {
                grabSize = 65536 - this.logControlDescriptor.nextLSN.offset;
            }
            boolean allocateSuccess = false;
            do {
                try {
                    logEDP.fileHandle.allocFileStorage(grabSize);
                }
                catch (LogException le) {
                    if (le.errorCode == 11) {
                        if (!this.cushionExists) {
                            if (cushionFreed) {
                                this.restoreCushion(false);
                            }
                            throw new LogException(11, 11, null, le);
                        }
                        this.freeCushion();
                        cushionFreed = true;
                        try {
                            logEDP = this.positionFilePointer(this.logControlDescriptor.nextLSN, 0, 2);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    allocateSuccess = false;
                }
            } while (!(allocateSuccess = true));
            this.chunkRemaining = grabSize - recordSize;
        }
        int bytesWritten = logEDP.fileHandle.fileWrite(writeBytes);
        logEDP.writtenSinceLastForce = true;
        logEDP.cursorPosition += bytesWritten;
        if (writeMode == 1) {
            Enumeration extents = this.extentTable.elements();
            while (extents.hasMoreElements()) {
                LogExtent nextEDP = (LogExtent)extents.nextElement();
                if (!nextEDP.writtenSinceLastForce) continue;
                try {
                    nextEDP.fileHandle.fileSync();
                    nextEDP.writtenSinceLastForce = false;
                }
                catch (LogException le) {
                    throw new LogException(13, 14, sm.getString("jts.log_file_sync_failed"), le);
                }
            }
        }
        this.logControlDescriptor.headLSN.copy(logRH.currentLSN);
        this.logControlDescriptor.nextLSN.copy(logRH.nextLSN);
        ++this.recordsWritten;
        if (this.recordsWritten >= 100) {
            this.writeControlFile();
            this.recordsWritten = 0;
        }
        if (cushionFreed) {
            this.restoreCushion(true);
        }
        LogLSN result = new LogLSN(logRH.currentLSN);
        return result;
    }

    synchronized byte[] readRecord(LogLSN readLSN, int[] type) throws LogException {
        LogLSN lsn;
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControlDescriptor.headLSN.isNULL()) {
            throw new LogException(null, 14, 3);
        }
        if (readLSN.equals(LogLSN.HEAD_LSN)) {
            lsn = this.logControlDescriptor.headLSN;
        } else if (readLSN.equals(LogLSN.TAIL_LSN)) {
            lsn = this.logControlDescriptor.tailLSN;
        } else {
            if (readLSN.lessThan(this.logControlDescriptor.tailLSN) || readLSN.greaterThan(this.logControlDescriptor.headLSN)) {
                throw new LogException(null, 14, 4);
            }
            lsn = readLSN;
        }
        LogExtent logEDP = this.positionFilePointer(lsn, 0, 1);
        byte[] headerBytes = new byte[32];
        int bytesRead = 0;
        try {
            bytesRead = logEDP.fileHandle.fileRead(headerBytes);
        }
        catch (LogException le) {
            logEDP.lastAccess = 0;
            throw new LogException(le.errorCode, 6, sm.getString("jts.log_read_header_failed"), le);
        }
        LogRecordHeader logRH = new LogRecordHeader(headerBytes, 0);
        logEDP.cursorPosition += bytesRead;
        if (logRH.recordType == 65536 || !logRH.currentLSN.equals(lsn)) {
            throw new LogException(null, 14, 7);
        }
        byte[][] readVect = new byte[][]{new byte[logRH.recordLength], new byte[8]};
        try {
            bytesRead = logEDP.fileHandle.readVector(readVect);
        }
        catch (LogException le) {
            logEDP.lastAccess = 0;
            throw new LogException(le.errorCode, 9, sm.getString("jts.log_readvector_failed"), le);
        }
        LogRecordEnding logRE = new LogRecordEnding(readVect[1], 0);
        logEDP.cursorPosition += bytesRead;
        if (!logRE.currentLSN.equals(lsn)) {
            throw new LogException(null, 4, 10);
        }
        type[0] = logRH.recordType;
        return readVect[0];
    }

    synchronized void writeRestart(byte[] buffer) throws LogException {
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControl.logReadOnly) {
            throw new LogException(null, 27, 3);
        }
        if (buffer.length > 16360) {
            throw new LogException(null, 10, 4);
        }
        if (this.blockValid != this) {
            throw new LogException(null, 5, 5);
        }
        int alternate = LogHandle.alternateRestart(this.activeRestartVersion);
        int restartOffset = LogHandle.restartPosition(alternate);
        this.logFileHandle.fileSeek(restartOffset, 1);
        LogRestartDescriptor logRD = new LogRestartDescriptor();
        logRD.restartDataLength = buffer.length;
        logRD.timeStamp = (int)new Date().getTime();
        logRD.restartValid = restartOffset;
        byte[] writeBytes = new byte[24 + buffer.length];
        logRD.toBytes(writeBytes, 0);
        System.arraycopy(buffer, 0, writeBytes, 12, buffer.length);
        logRD.toBytes(writeBytes, 12 + buffer.length);
        this.logFileHandle.fileWrite(writeBytes);
        this.activeRestartVersion = alternate;
    }

    synchronized byte[] readRestart() throws LogException {
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.blockValid != this) {
            throw new LogException(null, 5, 3);
        }
        if (this.restartDataLength == 0) {
            return new byte[0];
        }
        int restartOffset = LogHandle.restartPosition(this.activeRestartVersion);
        this.logFileHandle.fileSeek(restartOffset, 1);
        byte[][] readVect = new byte[][]{new byte[12], new byte[this.restartDataLength], new byte[12]};
        this.logFileHandle.readVector(readVect);
        LogRestartDescriptor logRD = new LogRestartDescriptor(readVect[0], 0);
        LogRestartDescriptor logRDEnd = new LogRestartDescriptor(readVect[2], 0);
        if (logRD.restartValid != restartOffset || logRD.restartDataLength != this.restartDataLength || !logRD.equals(logRDEnd)) {
            throw new LogException(null, 4, 7);
        }
        return readVect[1];
    }

    synchronized void closeFile(boolean deleteFile) throws LogException {
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        this.blockValid = null;
        boolean forced = false;
        Enumeration extents = this.extentTable.elements();
        while (extents.hasMoreElements()) {
            LogExtent logEDP = (LogExtent)extents.nextElement();
            if (logEDP.writtenSinceLastForce) {
                logEDP.fileHandle.fileSync();
                logEDP.writtenSinceLastForce = false;
                forced = true;
            }
            logEDP.fileHandle.fileClose();
            if (deleteFile) {
                LogExtent tmplogEDP = logEDP;
                Boolean isdeleted = tmplogEDP.file.delete();
                if (!isdeleted.booleanValue()) {
                    throw new LogException(null, 8, 6);
                }
            }
            this.extentTable.remove(logEDP.extentNumber);
            logEDP.doFinalize();
        }
        if (forced && !this.logControl.logReadOnly) {
            this.writeControlFile();
        }
        this.logFileHandle.fileClose();
        if (deleteFile) {
            Boolean isdeleted = this.logControl.controlFile.delete();
            if (!isdeleted.booleanValue()) {
                throw new LogException(null, 8, 7);
            }
            this.freeCushion();
            LogControl.directory(this.logFileName, this.logControl.directoryPath).delete();
        }
        this.logControl.removeFile(this);
    }

    synchronized void truncate(LogLSN truncLSN, int inclusive) throws LogException {
        LogLSN newTailRecord;
        LogLSN truncationRecord;
        LogLSN lsn;
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControl.logReadOnly) {
            throw new LogException(null, 27, 3);
        }
        if (this.logControlDescriptor.headLSN.isNULL()) {
            if (truncLSN.equals(LogLSN.HEAD_LSN)) {
                return;
            }
            throw new LogException(null, 15, 6);
        }
        boolean truncateHead = false;
        if (truncLSN.equals(LogLSN.HEAD_LSN) || truncLSN.equals(this.logControlDescriptor.headLSN)) {
            lsn = new LogLSN(this.logControlDescriptor.headLSN);
            truncateHead = true;
        } else {
            lsn = truncLSN.equals(LogLSN.TAIL_LSN) ? new LogLSN(this.logControlDescriptor.tailLSN) : new LogLSN(truncLSN);
        }
        if (lsn.lessThan(this.logControlDescriptor.tailLSN)) {
            throw new LogException(null, 16, 7);
        }
        if (lsn.greaterThan(this.logControlDescriptor.headLSN)) {
            throw new LogException(null, 15, 8);
        }
        boolean truncLastExtent = false;
        if (truncateHead && inclusive == 0) {
            truncationRecord = new LogLSN(lsn);
            newTailRecord = new LogLSN(this.logControlDescriptor.nextLSN);
        } else {
            if (inclusive == 1 && lsn.equals(this.logControlDescriptor.tailLSN)) {
                return;
            }
            LogExtent logEDP = this.positionFilePointer(lsn, 0, 1);
            byte[] headerBytes = new byte[32];
            int bytesRead = 0;
            try {
                bytesRead = logEDP.fileHandle.fileRead(headerBytes);
            }
            catch (LogException le) {
                logEDP.lastAccess = 0;
                throw new LogException(3, 11, sm.getString("jts.log_read_header_failed"), le);
            }
            logEDP.cursorPosition += bytesRead;
            LogRecordHeader recordHeader = new LogRecordHeader(headerBytes, 0);
            if (recordHeader.recordType == 65536) {
                throw new LogException(null, 17, 12);
            }
            if (inclusive == 1) {
                truncationRecord = new LogLSN(recordHeader.previousLSN);
                newTailRecord = new LogLSN(lsn);
                if (lsn.offset == 0) {
                    truncLastExtent = true;
                }
            } else {
                truncationRecord = new LogLSN(lsn);
                newTailRecord = new LogLSN(recordHeader.nextLSN);
            }
        }
        int firstExtent = this.logControlDescriptor.tailLSN.extent;
        int lastExtent = truncationRecord.extent;
        if (truncateHead && inclusive == 0) {
            this.logControlDescriptor.tailLSN.copy(newTailRecord);
            this.logControlDescriptor.headLSN.copy(LogLSN.NULL_LSN);
        } else {
            this.logControlDescriptor.tailLSN.copy(newTailRecord);
        }
        this.writeControlFile();
        if (truncLastExtent) {
            ++lastExtent;
        }
        for (int extent = firstExtent; extent <= lastExtent - 1; ++extent) {
            LogExtent logEDP = (LogExtent)this.extentTable.get(extent);
            if (logEDP == null) continue;
            logEDP.fileHandle.fileClose();
            Boolean isdeleted = logEDP.file.delete();
            if (!isdeleted.booleanValue()) {
                throw new LogException(null, 8, 15);
            }
            this.extentTable.remove(extent);
            logEDP.doFinalize();
        }
        if (!this.cushionExists && firstExtent <= lastExtent - 1) {
            this.restoreCushion(false);
        }
        if (this.logControlDescriptor.tailLSN.offset > 0) {
            this.freeFileStorage(this.logControlDescriptor.tailLSN);
        }
        if (this.logControlDescriptor.headLSN.isNULL()) {
            this.recordsWritten = 100;
        }
    }

    synchronized void checkLSN(LogLSN chkLSN) throws LogException {
        int firstExtent;
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        if (this.logControl.logReadOnly) {
            throw new LogException(null, 27, 3);
        }
        LogLSN lsn = chkLSN.equals(LogLSN.HEAD_LSN) ? new LogLSN(this.logControlDescriptor.headLSN) : (chkLSN.equals(LogLSN.TAIL_LSN) ? new LogLSN(this.logControlDescriptor.tailLSN) : new LogLSN(chkLSN));
        if (lsn.lessThan(this.logControlDescriptor.tailLSN)) {
            return;
        }
        if (this.logControlDescriptor.headLSN.isNULL()) {
            return;
        }
        if (lsn.greaterThan(this.logControlDescriptor.headLSN)) {
            lsn.copy(this.logControlDescriptor.headLSN);
        }
        int lastExtent = lsn.extent;
        for (int extent = firstExtent = this.logControlDescriptor.tailLSN.extent; extent <= lastExtent; ++extent) {
            LogExtent logEDP = (LogExtent)this.extentTable.get(extent);
            if (logEDP == null || !logEDP.writtenSinceLastForce) continue;
            logEDP.fileHandle.fileSync();
            logEDP.writtenSinceLastForce = false;
        }
    }

    synchronized LogCursor openCursor(LogLSN startLSN, LogLSN endLSN) throws LogException {
        if (this.blockValid != this) {
            throw new LogException(null, 5, 1);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 2);
        }
        LogCursor cursor = new LogCursor(this.logControl, this, startLSN, endLSN);
        if (cursor == null) {
            throw new LogException(null, 12, 4);
        }
        this.cursors.add(cursor);
        return cursor;
    }

    synchronized void closeCursor(LogCursor cursor) throws LogException {
        if (cursor == null || cursor.blockValid != cursor) {
            throw new LogException(null, 20, 1);
        }
        if (this.blockValid != this) {
            throw new LogException(null, 20, 2);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 3);
        }
        this.cursors.remove(cursor);
    }

    LogExtent positionFilePointer(LogLSN currentLSN, int extra, int accessType) throws LogException {
        boolean extentJustOpened = false;
        LogExtent extent = (LogExtent)this.extentTable.get(currentLSN.extent);
        if (extent == null) {
            extent = this.openExtent(currentLSN.extent);
            extentJustOpened = true;
        }
        if (extent.cursorPosition != currentLSN.offset + extra || extent.lastAccess != accessType) {
            int seekDist = currentLSN.offset + extra > extent.cursorPosition ? currentLSN.offset + extra - extent.cursorPosition : extent.cursorPosition - currentLSN.offset - extra;
            try {
                if (extent.lastAccess == 0 || currentLSN.offset + extra < seekDist) {
                    extent.fileHandle.fileSeek(currentLSN.offset + extra, 1);
                } else {
                    extent.fileHandle.fileSeek(currentLSN.offset + extra - extent.cursorPosition, 0);
                }
            }
            catch (LogException le) {
                if (extentJustOpened) {
                    this.extentTable.remove(currentLSN.extent);
                    extent.doFinalize();
                }
                throw new LogException(3, 3, null, le);
            }
            extent.cursorPosition = currentLSN.offset + extra;
            extent.lastAccess = accessType;
        }
        return extent;
    }

    private void freeCushion() {
        if (this.cushionExists) {
            this.logControl.cushionFile.delete();
            this.cushionExists = false;
        }
    }

    void restoreCushion(boolean callUpcall) throws LogException {
        if (!this.logControl.cushionFile.exists()) {
            LogFileHandle cushionFH;
            int openOptions = 14;
            try {
                cushionFH = new LogFileHandle(this.logControl.cushionFile, openOptions);
            }
            catch (LogException le) {
                if (callUpcall && !this.upcallInProgress) {
                    this.upcallInProgress = true;
                    this.upcallTarget.upcall(1);
                    this.upcallInProgress = false;
                }
                throw new LogException(2, 3, null, le);
            }
            try {
                cushionFH.allocFileStorage(65536);
            }
            catch (LogException le) {
                cushionFH.destroy();
                this.logControl.cushionFile.delete();
                if (callUpcall && !this.upcallInProgress) {
                    this.upcallInProgress = true;
                    this.upcallTarget.upcall(1);
                    this.upcallInProgress = false;
                }
                this.cushionExists = false;
                throw new LogException(2, 4, null, le);
            }
            cushionFH.destroy();
        }
        this.cushionExists = true;
    }

    void writeControlFile() throws LogException {
        Enumeration extents = this.extentTable.elements();
        while (extents.hasMoreElements()) {
            LogExtent nextEDP = (LogExtent)extents.nextElement();
            if (!nextEDP.writtenSinceLastForce) continue;
            try {
                nextEDP.fileHandle.fileSync();
                nextEDP.writtenSinceLastForce = false;
            }
            catch (LogException le) {
                throw new LogException(13, 14, null, le);
            }
        }
        this.logFileHandle.fileSeek(0L, 1);
        byte[] controlBytes = new byte[24];
        this.logControlDescriptor.toBytes(controlBytes, 0);
        this.logFileHandle.fileWrite(controlBytes);
    }

    LogExtent openExtent(int extent) throws LogException {
        File extentFile = this.logControl.extentFile(this.logFileName, LogExtent.modExtent(extent));
        int openOptions = 6;
        if (this.logControl.logReadOnly) {
            openOptions = 1;
        }
        LogFileHandle extentFH = new LogFileHandle(extentFile, openOptions);
        LogExtent logEDP = new LogExtent(extent, extentFH, extentFile);
        this.extentTable.put(extent, logEDP);
        logEDP.blockValid = logEDP;
        return logEDP;
    }

    void freeFileStorage(LogLSN tailLSN) throws LogException {
        int bytesToClear = tailLSN.offset;
        if (bytesToClear == 0) {
            return;
        }
        LogLSN startOfExtent = new LogLSN(tailLSN.extent, 0);
        LogExtent logEDP = this.positionFilePointer(startOfExtent, 0, 0);
        logEDP.fileHandle.fileSync();
    }

    static void checkRestart(LogFileHandle fileHandle, int restartNumber, int[] restartInfo) throws LogException {
        restartInfo[0] = 0;
        restartInfo[1] = 0;
        byte[] restartBytes = new byte[12];
        int offset = LogHandle.restartPosition(restartNumber);
        fileHandle.fileSeek(offset, 1);
        int bytesRead = fileHandle.fileRead(restartBytes);
        LogRestartDescriptor logRD = new LogRestartDescriptor(restartBytes, 0);
        if (bytesRead > 0 && logRD.restartValid == LogHandle.restartPosition(restartNumber)) {
            fileHandle.fileSeek(logRD.restartDataLength, 0);
            fileHandle.fileRead(restartBytes);
            LogRestartDescriptor logRDEnd = new LogRestartDescriptor(restartBytes, 0);
            if (logRD.equals(logRDEnd)) {
                restartInfo[0] = logRD.restartDataLength;
                restartInfo[1] = logRD.timeStamp;
            } else {
                throw new LogException(null, 4, 1);
            }
        }
    }

    void dump() throws LogException {
    }

    void cleanUpExtents() {
        Enumeration extents = this.extentTable.elements();
        while (extents.hasMoreElements()) {
            LogExtent logEDP = (LogExtent)extents.nextElement();
            this.extentTable.remove(logEDP.extentNumber);
            logEDP.doFinalize();
        }
        this.extentTable = null;
    }

    static final int alternateRestart(int restart) {
        return restart == 1 ? 2 : 1;
    }

    static final int restartPosition(int restart) {
        return restart == 1 ? 4096 : 20480;
    }

    final String logFileName() {
        return this.logFileName;
    }
}

