/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.cdi.asynchronous;

import jakarta.annotation.Priority;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.CronTrigger;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.Schedule;
import jakarta.enterprise.concurrent.Trigger;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.time.ZoneId;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.concurro.internal.AsynchronousScheduledAction;
import org.glassfish.concurro.internal.CompoundTrigger;
import org.glassfish.concurro.internal.ManagedCompletableFuture;

@Interceptor
@Asynchronous
@Priority(value=5)
public class AsynchronousInterceptor {
    private static final System.Logger LOG = System.getLogger(AsynchronousInterceptor.class.getName());

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        Asynchronous asynchAnnotation = (Asynchronous)context.getInterceptorBinding(Asynchronous.class);
        if (asynchAnnotation.runAt().length > 0) {
            return this.schedule(context, method, asynchAnnotation);
        }
        return this.executeDirectly(context, method, asynchAnnotation);
    }

    private CompletableFuture<Object> executeDirectly(InvocationContext context, Method method, Asynchronous asynchAnnotation) {
        String executor = asynchAnnotation.executor();
        executor = executor != null ? executor : "java:comp/DefaultManagedExecutorService";
        LOG.log(System.Logger.Level.DEBUG, "AsynchronousInterceptor.intercept around asynchronous method {0}, executor=''{1}''", method, executor);
        ManagedExecutorService mes = AsynchronousInterceptor.lookupMES(ManagedExecutorService.class, executor, method.getName());
        ManagedCompletableFuture<Object> resultFuture = new ManagedCompletableFuture<Object>(mes);
        mes.submit(() -> {
            CompletableFuture returnedFuture;
            block14: {
                Asynchronous.Result.setFuture((CompletableFuture)resultFuture);
                returnedFuture = resultFuture;
                try {
                    returnedFuture = (CompletableFuture)context.proceed();
                    if (returnedFuture.isDone()) break block14;
                }
                catch (Exception ex) {
                    block15: {
                        try {
                            resultFuture.completeExceptionally(ex);
                            if (returnedFuture.isDone()) break block15;
                        }
                        catch (Throwable throwable) {
                            if (!returnedFuture.isDone()) {
                                LOG.log(System.Logger.Level.ERROR, "Method annotated with @Asynchronous did not call Asynchronous.Result.complete() at its end: {0}", method);
                                Asynchronous.Result.getFuture().cancel(true);
                            }
                            if (returnedFuture != Asynchronous.Result.getFuture()) {
                                try {
                                    resultFuture.complete(returnedFuture.get());
                                }
                                catch (InterruptedException | ExecutionException e) {
                                    resultFuture.completeExceptionally(e);
                                }
                            }
                            Asynchronous.Result.setFuture(null);
                            throw throwable;
                        }
                        LOG.log(System.Logger.Level.ERROR, "Method annotated with @Asynchronous did not call Asynchronous.Result.complete() at its end: {0}", method);
                        Asynchronous.Result.getFuture().cancel(true);
                    }
                    if (returnedFuture != Asynchronous.Result.getFuture()) {
                        try {
                            resultFuture.complete(returnedFuture.get());
                        }
                        catch (InterruptedException | ExecutionException e) {
                            resultFuture.completeExceptionally(e);
                        }
                    }
                    Asynchronous.Result.setFuture(null);
                }
                LOG.log(System.Logger.Level.ERROR, "Method annotated with @Asynchronous did not call Asynchronous.Result.complete() at its end: {0}", method);
                Asynchronous.Result.getFuture().cancel(true);
            }
            if (returnedFuture != Asynchronous.Result.getFuture()) {
                try {
                    resultFuture.complete(returnedFuture.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    resultFuture.completeExceptionally(e);
                }
            }
            Asynchronous.Result.setFuture(null);
        });
        return resultFuture;
    }

    private static <T> T lookupMES(Class<T> cls, String executor, String methodName) throws RejectedExecutionException {
        Object mes;
        try {
            Object lookupMes = new InitialContext().lookup(executor);
            if (lookupMes == null) {
                throw new RejectedExecutionException("ManagedExecutorService with jndi '" + executor + "' not found!");
            }
            if (!cls.isInstance(lookupMes)) {
                throw new RejectedExecutionException("ManagedExecutorService with jndi '" + executor + "' must be of type " + String.valueOf(cls) + ", found " + lookupMes.getClass().getName());
            }
            mes = lookupMes;
        }
        catch (NamingException ex) {
            throw new RejectedExecutionException("ManagedExecutorService with jndi '" + executor + "' not found as requested by asynchronous method " + methodName);
        }
        return (T)mes;
    }

    public CompletableFuture<Object> schedule(InvocationContext context, Method method, Asynchronous asynchAnnotation) {
        String executor = asynchAnnotation.executor();
        executor = executor != null ? executor : "java:comp/DefaultManagedExecutorService";
        AsynchronousInterceptor.lookupMES(ManagedExecutorService.class, executor, method.getName());
        ManagedScheduledExecutorService mses = AsynchronousInterceptor.lookupMES(ManagedScheduledExecutorService.class, "java:comp/DefaultManagedScheduledExecutorService", method.getName());
        CompletableFuture future = mses.newIncompleteFuture();
        CompoundTrigger compoundTrigger = new CompoundTrigger(mses);
        for (Schedule schedule : asynchAnnotation.runAt()) {
            long skipIfLateBySeconds = schedule.skipIfLateBy();
            ZoneId zone = schedule.zone().isEmpty() ? ZoneId.systemDefault() : ZoneId.of(schedule.zone());
            CronTrigger trigger = AsynchronousInterceptor.getCronTrigger(schedule, zone);
            compoundTrigger.addTrigger(trigger, skipIfLateBySeconds);
        }
        AsynchronousScheduledAction action = new AsynchronousScheduledAction(context, future);
        ScheduledFuture scheduledFuture = mses.schedule((Runnable)action, (Trigger)compoundTrigger);
        action.setScheduledFuture(scheduledFuture);
        return future;
    }

    static final CronTrigger getCronTrigger(Schedule schedule, ZoneId zone) {
        if (schedule.cron().isEmpty()) {
            CronTrigger trigger = new CronTrigger(zone);
            AsynchronousInterceptor.setIfNotEmpty(arg_0 -> ((CronTrigger)trigger).seconds(arg_0), schedule.seconds());
            AsynchronousInterceptor.setIfNotEmpty(arg_0 -> ((CronTrigger)trigger).minutes(arg_0), schedule.minutes());
            AsynchronousInterceptor.setIfNotEmpty(arg_0 -> ((CronTrigger)trigger).hours(arg_0), schedule.hours());
            AsynchronousInterceptor.setIfNotEmpty(arg_0 -> ((CronTrigger)trigger).daysOfWeek(arg_0), schedule.daysOfWeek());
            AsynchronousInterceptor.setIfNotEmpty(arg_0 -> ((CronTrigger)trigger).daysOfMonth(arg_0), schedule.daysOfMonth());
            AsynchronousInterceptor.setIfNotEmpty(arg_0 -> ((CronTrigger)trigger).months(arg_0), schedule.months());
            return trigger;
        }
        return new CronTrigger(schedule.cron(), zone);
    }

    static final void setIfNotEmpty(Consumer<int[]> consumer, int[] data) {
        Optional.ofNullable(data).filter(a -> ((int[])a).length > 0).ifPresent(consumer);
    }

    static final <T> void setIfNotEmpty(Consumer<T[]> consumer, T[] data) {
        Optional.ofNullable(data).filter(a -> ((Object[])a).length > 0).ifPresent(consumer);
    }
}

