/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.api;

import com.sun.enterprise.config.serverbeans.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceProxy;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;

@Service
public class ResourcesBinder {
    @Inject
    private GlassfishNamingManager manager;
    @LogMessagesResourceBundle
    public static final String LOGMESSAGE_RESOURCE = "org.glassfish.resourcebase.resources.LogMessages";
    @LoggerInfo(subsystem="RESOURCE", description="Nucleus Resource", publish=true)
    public static final String LOGGER = "jakarta.enterprise.resources.api";
    private static final Logger logger = Logger.getLogger("jakarta.enterprise.resources.api", "org.glassfish.resourcebase.resources.LogMessages");
    @Inject
    private Provider<ResourceProxy> resourceProxyProvider;
    @Inject
    private ResourceNamingService resourceNamingService;

    public void deployResource(ResourceInfo resourceInfo, Resource resource) {
        try {
            this.bindResource(resourceInfo, resource);
        }
        catch (NamingException ne) {
            Object[] params = new Object[]{resourceInfo, ne};
            logger.log(Level.SEVERE, "NCLS-RESOURCE-00003", params);
        }
    }

    private void bindResource(ResourceInfo resourceInfo, Resource resource) throws NamingException {
        ResourceProxy proxy = (ResourceProxy)this.resourceProxyProvider.get();
        proxy.setResource(resource);
        proxy.setResourceInfo(resourceInfo);
        this.resourceNamingService.publishObject(resourceInfo, proxy, true);
    }
}

