/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.sse.impl;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.glassfish.sse.api.ServerSentEventHandler;
import org.glassfish.sse.impl.ServerSentEventConnectionImpl;
import org.glassfish.sse.impl.ServerSentEventHandlerContextImpl;

final class ServerSentEventApplication {
    private final Set<ServerSentEventHandler> handlers;
    private final String path;
    private final ServerSentEventHandlerContextImpl context;
    private final Class<?> clazz;

    ServerSentEventApplication(Class<?> clazz, String path) {
        this.clazz = clazz;
        this.path = path;
        this.handlers = new CopyOnWriteArraySet<ServerSentEventHandler>();
        this.context = new ServerSentEventHandlerContextImpl(path, this.handlers);
    }

    ServerSentEventConnectionImpl createConnection(HttpServletRequest request, ServerSentEventHandler sseh, CreationalContext<?> cc, AsyncContext ac) {
        ServerSentEventConnectionImpl con = new ServerSentEventConnectionImpl(this, request, sseh, cc, ac);
        this.handlers.add(sseh);
        return con;
    }

    void destroyConnection(ServerSentEventConnectionImpl connection) {
        this.handlers.remove(connection.sseh);
    }

    ServerSentEventHandlerContextImpl getHandlerContext() {
        return this.context;
    }

    Class<?> getHandlerClass() {
        return this.clazz;
    }

    String getPath() {
        return this.path;
    }
}

