/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.domain;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.JwtClaims;
import jakarta.security.enterprise.identitystore.openid.Scope;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.glassfish.soteria.mechanisms.openid.domain.NimbusJwtClaims;

public class AccessTokenImpl
implements AccessToken {
    private final String token;
    private final long tokenMinValidity;
    private final AccessToken.Type type;
    private final JwtClaims jwtClaims;
    private JWT tokenJWT;
    private Map<String, Object> claims;
    private final Long expiresIn;
    private final Scope scope;
    private final long createdAt;

    public AccessTokenImpl(String tokenType, String token, Long expiresIn, String scopeValue, long tokenMinValidity) {
        this.token = token;
        this.tokenMinValidity = tokenMinValidity;
        JWTClaimsSet jwtClaimsSet = null;
        try {
            this.tokenJWT = JWTParser.parse((String)token);
            jwtClaimsSet = this.tokenJWT.getJWTClaimsSet();
            this.claims = this.ifPresent(jwtClaimsSet);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.jwtClaims = NimbusJwtClaims.ifPresent(jwtClaimsSet);
        this.type = AccessToken.Type.valueOf((String)tokenType.toUpperCase());
        this.expiresIn = expiresIn;
        this.createdAt = System.currentTimeMillis();
        this.scope = Scope.parse((String)scopeValue);
    }

    public boolean isExpired() {
        boolean expired;
        if (Objects.nonNull(this.expiresIn)) {
            expired = System.currentTimeMillis() + this.tokenMinValidity > this.createdAt + this.expiresIn * 1000L;
        } else {
            Date exp = (Date)this.getClaim("exp");
            if (Objects.nonNull(exp)) {
                expired = System.currentTimeMillis() + this.tokenMinValidity > exp.getTime();
            } else {
                throw new IllegalStateException("Missing expiration time (exp) claim in access token");
            }
        }
        return expired;
    }

    public AccessToken.Type getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, Object> getClaims() {
        if (this.claims == null) {
            return Collections.emptyMap();
        }
        return this.claims;
    }

    public void setClaims(Map<String, Object> claims) {
        this.claims = claims;
    }

    public Object getClaim(String key) {
        return this.getClaims().get(key);
    }

    public Long getExpirationTime() {
        return this.expiresIn;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isJWT() {
        return this.tokenJWT != null;
    }

    public JwtClaims getJwtClaims() {
        return this.jwtClaims;
    }

    public String toString() {
        return this.token;
    }

    private Map<String, Object> ifPresent(JWTClaimsSet claimsSet) {
        return claimsSet == null ? null : claimsSet.getClaims();
    }
}

