/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Calendar;
import com.sun.webui.jsf.component.CalendarMonth;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.renderkit.html.FieldRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;

public class CalendarRenderer
extends FieldRenderer {
    private static final boolean DEBUG = false;

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component == null) {
            return;
        }
        if (!(component instanceof Calendar)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Calendar.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        Calendar calendar = (Calendar)component;
        boolean readOnly = calendar.isReadOnly();
        ResponseWriter writer = context.getResponseWriter();
        String[] styles = this.getStyles(calendar, context);
        String clientId = calendar.getClientId(context);
        this.renderTableStart(calendar, styles[18], styles[2], context, writer);
        UIComponent label = calendar.getLabelComponent(context, null);
        if (label != null) {
            this.renderCellStart(calendar, styles[6], writer);
            RenderingUtilities.renderComponent(label, context);
            this.renderCellEnd(writer);
        }
        if (readOnly) {
            this.renderCellStart(calendar, styles[6], writer);
            UIComponent text = calendar.getReadOnlyComponent(context);
            RenderingUtilities.renderComponent(text, context);
            if (calendar.getValue() != null) {
                this.renderPattern(calendar, styles[7], styles[2], context, writer);
            }
        } else {
            this.renderCellStart(calendar, styles[4], writer);
            this.renderInput(calendar, "text", clientId.concat("_field"), false, styles, context, writer);
            writer.write("\n");
            this.renderPattern(calendar, styles[7], styles[2], context, writer);
        }
        this.renderCellEnd(writer);
        if (!readOnly) {
            writer.startElement("td", (UIComponent)calendar);
            writer.writeAttribute("valign", (Object)"top", null);
            writer.writeText((Object)"\n", null);
            writer.startElement("div", (UIComponent)calendar);
            writer.writeAttribute("style", (Object)"position: relative;", null);
            writer.writeText((Object)"\n", null);
            writer.startElement("span", (UIComponent)calendar);
            writer.writeAttribute("class", (Object)styles[5], null);
            ImageHyperlink link = calendar.getDatePickerLink(context);
            if (calendar.isDisabled()) {
                writer.writeAttribute("style", (Object)"display:none;", null);
            }
            writer.write("\n");
            link.setIcon(styles[14]);
            link.setToolTip(styles[13]);
            RenderingUtilities.renderComponent((UIComponent)link, context);
            writer.endElement("span");
            writer.write("\n");
            this.renderDatePicker(context, writer, styles, calendar);
            writer.endElement("div");
            writer.writeText((Object)"\n", null);
            writer.endElement("td");
            writer.writeText((Object)"\n", null);
        }
        this.renderTableEnd(writer);
        writer.writeText((Object)"\n", null);
    }

    private void renderDatePicker(FacesContext context, ResponseWriter writer, String[] styles, Calendar calendar) throws IOException {
        CalendarMonth datePicker = calendar.getDatePicker();
        Object value = calendar.getSubmittedValue();
        if (value != null) {
            try {
                Object dO = ConversionUtilities.convertValueToObject((UIComponent)calendar, (String)value, context);
                datePicker.setValue(dO);
            }
            catch (Exception exception) {}
        } else if (calendar.getValue() != null) {
            datePicker.setValue(calendar.getValue());
        }
        datePicker.initCalendarControls(calendar.getJavaScriptObjectName(context));
        RenderingUtilities.renderComponent((UIComponent)datePicker, context);
        this.renderJavaScript(context, calendar, writer, styles);
    }

    private void renderTableStart(Calendar calendar, String rootStyle, String hiddenStyle, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("table", (UIComponent)calendar);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
        writer.writeAttribute("id", (Object)calendar.getClientId(context), "id");
        Object style = calendar.getStyle();
        if (style != null && ((String)style).length() > 0) {
            writer.writeAttribute("style", style, "style");
        }
        if ((style = (style = this.getStyleClass(calendar, hiddenStyle)) == null ? rootStyle : (String)style + " " + rootStyle) != null) {
            writer.writeAttribute("class", style, "class");
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)calendar);
        writer.writeText((Object)"\n", null);
    }

    private void renderCellStart(Calendar calendar, String style, ResponseWriter writer) throws IOException {
        writer.startElement("td", (UIComponent)calendar);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        writer.startElement("span", (UIComponent)calendar);
        writer.writeAttribute("class", (Object)style, null);
        writer.writeText((Object)"\n", null);
    }

    private void renderCellEnd(ResponseWriter writer) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.endElement("span");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
    }

    private void renderTableEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }

    private void renderPattern(Calendar calendar, String styleClass, String hiddenStyle, FacesContext context, ResponseWriter writer) throws IOException {
        String hint = calendar.getDateFormatPatternHelp();
        if (hint == null) {
            try {
                String pattern = calendar.getDatePicker().getDateFormatPattern();
                hint = ThemeUtilities.getTheme(context).getMessage("calendar.".concat(pattern));
            }
            catch (MissingResourceException mre) {
                hint = ((SimpleDateFormat)calendar.getDateFormat()).toLocalizedPattern().toLowerCase();
            }
        }
        if (hint != null) {
            writer.startElement("div", (UIComponent)calendar);
            String id = calendar.getClientId(context);
            id = id.concat("_pattern");
            writer.writeAttribute("id", (Object)id, null);
            String style = styleClass;
            if (calendar.isDisabled()) {
                style = style.concat(" ").concat(hiddenStyle);
            }
            writer.writeAttribute("class", (Object)style, null);
            writer.writeText((Object)hint, null);
            writer.endElement("div");
        }
    }

    private void renderJavaScript(FacesContext context, Calendar calendar, ResponseWriter writer, String[] styles) throws IOException {
        int firstDay = calendar.getDatePicker().getCalendar().getFirstDayOfWeek();
        String day = null;
        switch (firstDay) {
            case 1: {
                day = "0";
                break;
            }
            case 2: {
                day = "1";
                break;
            }
            case 6: {
                day = "5";
                break;
            }
            case 7: {
                day = "6";
                break;
            }
            case 3: {
                day = "2";
                break;
            }
            case 4: {
                day = "3";
                break;
            }
            case 5: {
                day = "4";
                break;
            }
        }
        String clientId = calendar.getClientId(context);
        CalendarMonth datePicker = calendar.getDatePicker();
        String datePickerId = datePicker.getClientId(context);
        JsonObject initProps = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("id", calendar.getClientId(context)).add("firstDay", day).add("fieldId", clientId.concat("_field")).add("patternId", clientId.concat("_pattern")).add("calendarToggleId", calendar.getDatePickerLink(context).getClientId(context)).add("datePickerId", datePickerId).add("monthMenuId", datePicker.getMonthMenu().getClientId(context)).add("yearMenuId", datePicker.getYearMenu().getClientId(context)).add("rowId", datePickerId + ":row5").add("showButtonSrc", styles[8]).add("hideButtonSrc", styles[9]).add("dateFormat", datePicker.getDateFormatPattern()).add("dateClass", styles[10]).add("edgeClass", styles[11]).add("selectedClass", styles[15]).add("edgeSelectedClass", styles[16]).add("todayClass", styles[17]).add("hiddenClass", styles[2]).build();
        JavaScriptUtilities.renderInitScriptTag(writer, "calendar", initProps);
    }

    private String[] getStyles(Calendar calendar, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[]{theme.getStyleClass("TEXT_FIELD"), theme.getStyleClass("TEXT_FIELD_DISABLED"), theme.getStyleClass("HIDDEN"), "", "", theme.getStyleClass("CALENDAR_FIELD_IMAGE"), theme.getStyleClass("CALENDAR_FIELD_LABEL"), theme.getStyleClass("HELP_FIELD_TEXT"), theme.getImagePath("CALENDAR_BUTTON"), theme.getImagePath("CALENDAR_BUTTON_FLIP"), theme.getStyleClass("DATE_TIME_LINK"), theme.getStyleClass("DATE_TIME_OTHER_LINK"), null, theme.getMessage("calendar.popupImageAlt"), "CALENDAR_BUTTON", theme.getStyleClass("DATE_TIME_BOLD_LINK"), theme.getStyleClass("DATE_TIME_OTHER_BOLD_LINK"), theme.getStyleClass("DATE_TIME_TODAY_LINK"), theme.getStyleClass("CALENDAR_ROOT_TABLE")};
        return styles;
    }

    private static void log(String msg) {
        LogUtil.finest(CalendarRenderer.class.getName() + "::" + msg);
    }
}

