/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.cdi.types;

import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.krazo.binding.validate.ValidationInterceptorBinding;
import org.eclipse.krazo.cdi.AroundController;
import org.eclipse.krazo.cdi.types.AnnotatedMethodWrapper;
import org.eclipse.krazo.cdi.types.AnnotatedTypeWrapper;
import org.eclipse.krazo.util.ControllerUtils;

public class AnnotatedTypeProcessor {
    private static final Logger log = Logger.getLogger(AnnotatedTypeProcessor.class.getName());

    public <T> AnnotatedType<T> getReplacement(AnnotatedType<T> originalType) {
        boolean modified = false;
        LinkedHashSet methods = new LinkedHashSet();
        for (AnnotatedMethod originalMethod : originalType.getMethods()) {
            AnnotatedMethod<T> replacement = this.getReplacement(originalType, originalMethod);
            if (replacement != null) {
                methods.add(replacement);
                modified = true;
                continue;
            }
            methods.add(originalMethod);
        }
        if (modified) {
            return new AnnotatedTypeWrapper(originalType, methods);
        }
        return null;
    }

    private <T> AnnotatedMethod<? super T> getReplacement(AnnotatedType<T> type, AnnotatedMethod<? super T> method) {
        LinkedHashSet<Annotation> markerAnnotations = new LinkedHashSet<Annotation>(Arrays.asList(() -> ValidationInterceptorBinding.class, () -> AroundController.class));
        Predicate<Class> annotationBlacklist = this::isHibernateValidatorMarkerAnnotation;
        if (ControllerUtils.isControllerMethod(method.getJavaMember())) {
            log.log(Level.FINE, "Found controller method: {0}#{1}", new Object[]{type.getJavaClass().getName(), method.getJavaMember().getName()});
            return new AnnotatedMethodWrapper<T>(method, markerAnnotations, annotationBlacklist);
        }
        return null;
    }

    private boolean isHibernateValidatorMarkerAnnotation(Class<?> clazz) {
        return AnnotatedTypeProcessor.isOneOf(clazz.getName(), "org.hibernate.validator.cdi.internal.interceptor.MethodValidated", "org.hibernate.validator.cdi.interceptor.internal.MethodValidated", "org.hibernate.validator.internal.cdi.interceptor.MethodValidated");
    }

    @SafeVarargs
    private static <T> boolean isOneOf(T object, T ... objects) {
        for (T other : objects) {
            if (!(object == null ? other == null : object.equals(other))) continue;
            return true;
        }
        return false;
    }
}

