/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.audit.AuditManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecurityServicesUtil {
    private static ServiceLocator serviceLocator = Globals.getDefaultHabitat();
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private ServerEnvironment env;
    @Inject
    private AuditManager auditManager;
    private CallbackHandler callbackHandler;

    public ServiceLocator getHabitat() {
        return serviceLocator;
    }

    public AuditManager getAuditManager() {
        return this.auditManager;
    }

    public static SecurityServicesUtil getInstance() {
        if (serviceLocator == null) {
            return null;
        }
        return (SecurityServicesUtil)serviceLocator.getService(SecurityServicesUtil.class, new Annotation[0]);
    }

    public ProcessEnvironment getProcessEnv() {
        return this.processEnv;
    }

    public boolean isACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isServer() {
        return this.processEnv.getProcessType().isServer();
    }

    public boolean isNotServerOrACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }
}

