/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import org.eclipse.persistence.core.mappings.CoreMapping;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.sequenced.SequencedObject;
import org.eclipse.persistence.oxm.sequenced.Setting;

public class SequencedUnmarshalContext
implements UnmarshalContext {
    private Setting currentSetting;

    @Override
    public void startElement(UnmarshalRecord unmarshalRecord) {
        Setting parentSetting = null == this.currentSetting ? null : ("text()".equals(this.currentSetting.getName()) ? null : this.currentSetting);
        XPathFragment xPathFragment = unmarshalRecord.getXPathNode().getXPathFragment();
        this.currentSetting = null != xPathFragment ? new Setting(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName()) : new Setting();
        int levelIndex = unmarshalRecord.getLevelIndex();
        if (0 != levelIndex) {
            if (1 == levelIndex) {
                ((SequencedObject)unmarshalRecord.getCurrentObject()).getSettings().add(this.currentSetting);
            } else {
                parentSetting.addChild(this.currentSetting);
            }
        }
    }

    @Override
    public void characters(UnmarshalRecord unmarshalRecord) {
        if (null == this.currentSetting || null == this.currentSetting.getName()) {
            this.currentSetting = new Setting(null, "text()");
            ((SequencedObject)unmarshalRecord.getCurrentObject()).getSettings().add(this.currentSetting);
        } else if (!"text()".equals(this.currentSetting.getName())) {
            Setting parentSetting = this.currentSetting;
            this.currentSetting = new Setting(null, "text()");
            if (null != parentSetting) {
                parentSetting.addChild(this.currentSetting);
            }
        }
    }

    @Override
    public void endElement(UnmarshalRecord unmarshalRecord) {
        if (null == this.currentSetting) {
            return;
        }
        this.currentSetting = "text()".equals(this.currentSetting.getName()) ? (null == this.currentSetting.getParent() ? null : this.currentSetting.getParent().getParent()) : this.currentSetting.getParent();
    }

    @Override
    public void setAttributeValue(UnmarshalRecord unmarshalRecord, Object value, Mapping mapping) {
        this.currentSetting.setMapping((CoreMapping)((Object)mapping));
        this.currentSetting.setObject(unmarshalRecord.getCurrentObject());
        this.currentSetting.setValue(value);
    }

    @Override
    public void addAttributeValue(UnmarshalRecord unmarshalRecord, ContainerValue containerValue, Object value) {
        this.addAttributeValue(unmarshalRecord, containerValue, value, unmarshalRecord.getContainerInstance(containerValue));
    }

    @Override
    public void addAttributeValue(UnmarshalRecord unmarshalRecord, ContainerValue containerValue, Object value, Object collection) {
        this.currentSetting.setMapping((CoreMapping)((Object)containerValue.getMapping()));
        this.currentSetting.setObject(unmarshalRecord.getCurrentObject());
        this.currentSetting.addValue(value, true, collection);
    }

    @Override
    public void reference(Reference reference) {
        this.currentSetting.setObject(reference.getSourceObject());
        this.currentSetting.setMapping((CoreMapping)((Object)reference.getMapping()));
        reference.setSetting(this.currentSetting);
    }

    @Override
    public void unmappedContent(UnmarshalRecord unmarshalRecord) {
        Setting parentSetting = this.currentSetting.getParent();
        if (null == parentSetting) {
            ((SequencedObject)unmarshalRecord.getCurrentObject()).getSettings().remove(this.currentSetting);
        }
        this.currentSetting = parentSetting;
    }
}

