/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import com.sun.jsftemplating.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class IncludeInputStream
extends FilterInputStream {
    private boolean eol = true;
    private IncludeInputStream redirStream = null;
    private static final String INCLUDE = "include";
    private static final int INCLUDE_LEN = "include".length();
    private static final int MARK_LIMIT = 128;

    public IncludeInputStream(InputStream input) {
        super(input);
    }

    @Override
    public int read() throws IOException {
        int intChar = -1;
        if (this.redirStream != null) {
            intChar = this.redirStream.read();
            if (intChar != -1) {
                return intChar;
            }
            this.redirStream = null;
        }
        intChar = super.read();
        char ch = (char)intChar;
        if (this.eol) {
            if (ch == '#') {
                intChar = this.startInclude();
            } else {
                this.eol = false;
            }
        }
        if (ch == '\n' || ch == '\r') {
            this.eol = true;
        }
        return intChar;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int i;
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > bytes.length || len < 0 || off + len > bytes.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        bytes[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                if (bytes == null) continue;
                bytes[off + i] = (byte)c;
            }
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
        return i;
    }

    private int startInclude() throws IOException {
        String filename;
        URL url;
        int ch;
        this.mark(128);
        for (int count = 0; count < INCLUDE_LEN; ++count) {
            ch = super.read();
            if (Character.toLowerCase((char)ch) == INCLUDE.charAt(count)) continue;
            this.reset();
            return 35;
        }
        ch = super.read();
        while (ch == 32 || ch == 9) {
            ch = super.read();
        }
        if (ch == 34 || ch == 39) {
            ch = super.read();
        }
        StringBuffer buf = new StringBuffer("");
        while (ch != 34 && ch != 39 && ch != 10 && ch != 13 && ch != -1) {
            buf.append((char)ch);
            ch = super.read();
        }
        if (ch == 34 || ch == 39) {
            ch = super.read();
        }
        if ((url = FileUtil.searchForFile(filename = buf.toString(), null)) == null) {
            throw new FileNotFoundException(filename);
        }
        this.redirStream = new IncludeInputStream(new BufferedInputStream(url.openStream()));
        return this.redirStream.read();
    }

    public static void main(String[] args) {
        try {
            IncludeInputStream stream = new IncludeInputStream(new FileInputStream(args[0]));
            int ch = 10;
            while (ch != -1) {
                System.out.print((char)ch);
                ch = stream.read();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

