/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ConnectionCache;
import java.util.Collection;
import java.util.Iterator;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.NameValue;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public abstract class ConnectionCacheBase
implements ConnectionCache {
    protected static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static final String STAT_UNIT = "count";
    private static final String TOTAL_ID_STD = "TotalConnections";
    private static final String TOTAL_ID = "totalconnections";
    private static final String IDLE_ID_STD = "ConnectionsIdle";
    private static final String IDLE_ID = "connectionsidle";
    private static final String BUSY_ID_STD = "ConnectionsBusy";
    private static final String BUSY_ID = "connectionsbusy";
    private static final String TOTAL_DESC = "Total number of connections in the connection cache";
    private static final String IDLE_DESC = "Number of connections in the connection cache that are idle";
    private static final String BUSY_DESC = "Number of connections in the connection cache that are in use";
    protected ORB orb;
    protected long timestamp = 0L;
    protected String cacheType;
    protected String monitoringName;

    protected ConnectionCacheBase(ORB orb, String cacheType, String monitoringName) {
        this.orb = orb;
        this.cacheType = cacheType;
        this.monitoringName = monitoringName;
        this.dprintCreation();
    }

    @Override
    @NameValue
    public String getCacheType() {
        return this.cacheType;
    }

    @Override
    public synchronized void stampTime(Connection c) {
        c.setTimeStamp(this.timestamp++);
    }

    private CountStatistic makeCountStat(String name, String desc, long value) {
        CountStatisticImpl result = new CountStatisticImpl(name, STAT_UNIT, desc);
        result.setCount(value);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.backingStore();
        synchronized (object) {
            for (Object obj : this.values()) {
                ((Connection)obj).closeConnectionResources();
            }
        }
    }

    @ManagedAttribute(id="totalconnections")
    @Description(value="Total number of connections in the connection cache")
    private CountStatistic numberOfConnectionsAttr() {
        return this.makeCountStat(TOTAL_ID_STD, TOTAL_DESC, this.numberOfConnections());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numberOfConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            count = this.values().size();
        }
        return count;
    }

    @ManagedAttribute(id="connectionsidle")
    @Description(value="Number of connections in the connection cache that are idle")
    private CountStatistic numberOfIdleConnectionsAttr() {
        return this.makeCountStat(IDLE_ID_STD, IDLE_DESC, this.numberOfIdleConnections());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numberOfIdleConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator connections = this.values().iterator();
            while (connections.hasNext()) {
                if (((Connection)connections.next()).isBusy()) continue;
                ++count;
            }
        }
        return count;
    }

    @ManagedAttribute(id="connectionsbusy")
    @Description(value="Number of connections in the connection cache that are in use")
    private CountStatistic numberOfBusyConnectionsAttr() {
        return this.makeCountStat(BUSY_ID_STD, BUSY_DESC, this.numberOfBusyConnections());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numberOfBusyConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator connections = this.values().iterator();
            while (connections.hasNext()) {
                if (!((Connection)connections.next()).isBusy()) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public synchronized boolean reclaim() {
        Object backingStore;
        long numberOfConnections = this.numberOfConnections();
        this.reclaimInfo(numberOfConnections, this.orb.getORBData().getHighWaterMark(), this.orb.getORBData().getNumberToReclaim());
        if (numberOfConnections <= (long)this.orb.getORBData().getHighWaterMark()) {
            return false;
        }
        Object object = backingStore = this.backingStore();
        synchronized (object) {
            for (int i = 0; i < this.orb.getORBData().getNumberToReclaim(); ++i) {
                Connection toClose = null;
                long lru = Long.MAX_VALUE;
                for (Connection c : this.values()) {
                    if (c.isBusy() || c.getTimeStamp() >= lru) continue;
                    toClose = c;
                    lru = c.getTimeStamp();
                }
                if (toClose == null) {
                    return false;
                }
                try {
                    this.closingInfo(toClose);
                    toClose.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.connectionsReclaimedInfo(numberOfConnections - this.numberOfConnections());
        }
        return true;
    }

    @Override
    public String getMonitoringName() {
        return this.monitoringName;
    }

    public abstract Collection values();

    protected abstract Object backingStore();

    @InfoMethod
    private void creationInfo(String cacheType, String monitoringName) {
    }

    @Transport
    protected void dprintCreation() {
        this.creationInfo(this.getCacheType(), this.getMonitoringName());
    }

    @InfoMethod
    private void cacheStatsInfo(long numberOfConnections, long numberOfBusyConnections, long numberOfIdleConnections, int highWaterMark, int numberToReclaim) {
    }

    @Transport
    protected void cacheStatisticsInfo() {
        this.cacheStatsInfo(this.numberOfConnections(), this.numberOfBusyConnections(), this.numberOfIdleConnections(), this.orb.getORBData().getHighWaterMark(), this.orb.getORBData().getNumberToReclaim());
    }

    @InfoMethod
    private void reclaimInfo(long numberOfConnections, int highWaterMark, int numberToReclaim) {
    }

    @InfoMethod
    private void closingInfo(Connection toClose) {
    }

    @InfoMethod
    private void connectionsReclaimedInfo(long l) {
    }
}

