/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;
import org.apache.catalina.security.SecurityClassLoad;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.glassfish.main.jdke.props.SystemProperties;

public final class Bootstrap {
    private static final String CATALINA_HOME_TOKEN = "${catalina.home}";
    private static final String CATALINA_BASE_TOKEN = "${catalina.base}";
    private static final Logger log = LogFacade.getLogger();
    private int debug = 0;
    private Object catalinaDaemon = null;
    private ClassLoader commonLoader = null;
    private ClassLoader catalinaLoader = null;
    private ClassLoader sharedLoader = null;

    private void initClassLoaders() {
        try {
            ClassLoaderFactory.setDebug(this.debug);
            this.commonLoader = this.createClassLoader("common", null);
            if (this.commonLoader == null) {
                this.commonLoader = this.getClass().getClassLoader();
            }
            this.catalinaLoader = this.createClassLoader("server", this.commonLoader);
            this.sharedLoader = this.createClassLoader("shared", this.commonLoader);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00398", t);
            System.exit(1);
        }
    }

    private ClassLoader createClassLoader(String name, ClassLoader parent) throws Exception {
        String value = CatalinaProperties.getProperty(name + ".loader");
        if (value == null || value.equals("")) {
            return parent;
        }
        ArrayList<File> unpackedList = new ArrayList<File>();
        ArrayList<File> packedList = new ArrayList<File>();
        ArrayList<URL> urlList = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreElements()) {
            Object repository = tokenizer.nextToken();
            try {
                urlList.add(new URL((String)repository));
            }
            catch (MalformedURLException malformedURLException) {
                boolean packed = false;
                if (((String)repository).startsWith(CATALINA_HOME_TOKEN)) {
                    repository = Bootstrap.getCatalinaHome() + ((String)repository).substring(CATALINA_HOME_TOKEN.length());
                } else if (((String)repository).startsWith(CATALINA_BASE_TOKEN)) {
                    repository = Bootstrap.getCatalinaBase() + ((String)repository).substring(CATALINA_BASE_TOKEN.length());
                }
                if (((String)repository).endsWith("*.jar")) {
                    packed = true;
                    repository = ((String)repository).substring(0, ((String)repository).length() - "*.jar".length());
                }
                if (packed) {
                    packedList.add(new File((String)repository));
                    continue;
                }
                unpackedList.add(new File((String)repository));
            }
        }
        File[] unpacked = unpackedList.toArray(new File[unpackedList.size()]);
        File[] packed = packedList.toArray(new File[packedList.size()]);
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return ClassLoaderFactory.createClassLoader(unpacked, packed, urls, parent);
    }

    public void init() throws Exception {
        this.setCatalinaHome();
        this.setCatalinaBase();
        this.initClassLoaders();
        Thread.currentThread().setContextClassLoader(this.catalinaLoader);
        SecurityClassLoad.securityClassLoad(this.catalinaLoader);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Loading startup class");
        }
        Class<?> startupClass = this.catalinaLoader.loadClass("org.apache.catalina.startup.Catalina");
        Object startupInstance = startupClass.newInstance();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Setting startup class properties");
        }
        String methodName = "setParentClassLoader";
        Class[] paramTypes = new Class[]{Class.forName("java.lang.ClassLoader")};
        Object[] paramValues = new Object[]{this.sharedLoader};
        Method method = startupInstance.getClass().getMethod(methodName, paramTypes);
        method.invoke(startupInstance, paramValues);
        this.catalinaDaemon = startupInstance;
    }

    private void load(String[] arguments) throws Exception {
        Object[] param;
        Class[] paramTypes;
        String methodName = "load";
        if (arguments == null || arguments.length == 0) {
            paramTypes = null;
            param = null;
        } else {
            paramTypes = new Class[]{arguments.getClass()};
            param = new Object[]{arguments};
        }
        Method method = this.catalinaDaemon.getClass().getMethod(methodName, paramTypes);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Calling startup class " + String.valueOf(method));
        }
        method.invoke(this.catalinaDaemon, param);
    }

    public void init(String[] arguments) throws Exception {
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                if (!arguments[i].equals("-debug")) continue;
                this.debug = 1;
            }
        }
        this.init();
        this.load(arguments);
    }

    public void start() throws Exception {
        if (this.catalinaDaemon == null) {
            this.init();
        }
        Method method = this.catalinaDaemon.getClass().getMethod("start", null);
        method.invoke(this.catalinaDaemon, (Object[])null);
    }

    public void stop() throws Exception {
        Method method = this.catalinaDaemon.getClass().getMethod("stop", null);
        method.invoke(this.catalinaDaemon, (Object[])null);
    }

    public void stopServer() throws Exception {
        Method method = this.catalinaDaemon.getClass().getMethod("stopServer", null);
        method.invoke(this.catalinaDaemon, (Object[])null);
    }

    public void setAwait(boolean await) throws Exception {
        Class[] paramTypes = new Class[]{Boolean.TYPE};
        Object[] paramValues = new Object[]{await};
        Method method = this.catalinaDaemon.getClass().getMethod("setAwait", paramTypes);
        method.invoke(this.catalinaDaemon, paramValues);
    }

    public boolean getAwait() throws Exception {
        Class[] paramTypes = new Class[]{};
        Object[] paramValues = new Object[]{};
        Method method = this.catalinaDaemon.getClass().getMethod("getAwait", paramTypes);
        Boolean b = (Boolean)method.invoke(this.catalinaDaemon, paramValues);
        return b;
    }

    public void destroy() {
    }

    public void setCatalinaHome(String s) {
        SystemProperties.setProperty((String)"catalina.home", (String)s, (boolean)true);
    }

    public void setCatalinaBase(String s) {
        SystemProperties.setProperty((String)"catalina.base", (String)s, (boolean)true);
    }

    private void setCatalinaBase() {
        if (System.getProperty("catalina.base") != null) {
            return;
        }
        if (System.getProperty("catalina.home") == null) {
            SystemProperties.setProperty((String)"catalina.base", (String)System.getProperty("user.dir"), (boolean)true);
        } else {
            SystemProperties.setProperty((String)"catalina.base", (String)System.getProperty("catalina.home"), (boolean)true);
        }
    }

    private void setCatalinaHome() {
        if (System.getProperty("catalina.home") != null) {
            return;
        }
        File bootstrapJar = new File(System.getProperty("user.dir"), "bootstrap.jar");
        if (bootstrapJar.exists()) {
            try {
                SystemProperties.setProperty((String)"catalina.home", (String)new File(System.getProperty("user.dir"), "..").getCanonicalPath(), (boolean)true);
            }
            catch (Exception e) {
                SystemProperties.setProperty((String)"catalina.home", (String)System.getProperty("user.dir"), (boolean)true);
            }
        } else {
            SystemProperties.setProperty((String)"catalina.home", (String)System.getProperty("user.dir"), (boolean)true);
        }
    }

    public static String getCatalinaHome() {
        return System.getProperty("catalina.home", System.getProperty("user.dir"));
    }

    public static String getCatalinaBase() {
        return System.getProperty("catalina.base", Bootstrap.getCatalinaHome());
    }
}

