/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.dom;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface ThreadPool
extends ConfigBeanProxy,
PropertyBag {
    public static final String DEFAULT_THREAD_POOL_CLASS_NAME = "org.glassfish.grizzly.threadpool.GrizzlyExecutorService";
    public static final int IDLE_THREAD_TIMEOUT = 900;
    public static final int MAX_QUEUE_SIZE = 4096;
    public static final int MAX_THREADPOOL_SIZE = 5;
    public static final int MIN_THREADPOOL_SIZE = 5;

    @Attribute(defaultValue="org.glassfish.grizzly.threadpool.GrizzlyExecutorService")
    public String getClassname();

    public void setClassname(String var1);

    @Attribute(defaultValue="900", dataType=Integer.class)
    public String getIdleThreadTimeoutSeconds();

    public void setIdleThreadTimeoutSeconds(String var1);

    @Attribute(defaultValue="4096", dataType=Integer.class)
    public String getMaxQueueSize();

    public void setMaxQueueSize(String var1);

    @Attribute(defaultValue="5", dataType=Integer.class)
    public String getMaxThreadPoolSize();

    public void setMaxThreadPoolSize(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="5", dataType=Integer.class)
    public String getMinThreadPoolSize();

    public void setMinThreadPoolSize(String var1);

    @Attribute(required=true, key=true)
    public String getName();

    public void setName(String var1);

    @Attribute
    @Deprecated
    public String getThreadPoolId();

    public void setThreadPoolId(String var1);

    default public List<NetworkListener> findNetworkListeners() {
        NetworkConfig config = (NetworkConfig)this.getParent().getParent(NetworkConfig.class);
        Dom configProxy = Objects.requireNonNull(Dom.unwrap((ConfigBeanProxy)config));
        if (!configProxy.getProxyType().equals(NetworkConfig.class)) {
            config = (NetworkConfig)configProxy.element("network-config").createProxy();
        }
        ArrayList<NetworkListener> networkListeners = new ArrayList<NetworkListener>();
        for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
            if (!listener.getThreadPool().equals(this.getName())) continue;
            networkListeners.add(listener);
        }
        return networkListeners;
    }
}

