/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.InspectorPanel;
import com.sun.messaging.jmq.admin.apps.console.event.SelectionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeNode;

public abstract class TabledInspector
extends InspectorPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1955105658708757041L;
    private CObjTableModel model;
    private JTable table;

    @Override
    public JPanel createWorkPanel() {
        JPanel listPanel = new JPanel();
        this.model = new CObjTableModel();
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.table);
        listPanel.setLayout(new BorderLayout());
        listPanel.add((Component)scrollPane, "Center");
        return listPanel;
    }

    @Override
    public void clearSelection() {
        if (this.table != null) {
            this.table.clearSelection();
        }
    }

    @Override
    public void inspectorInit() {
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.clearSelection();
    }

    @Override
    public void selectedObjectUpdated() {
        if (this.table == null) {
            return;
        }
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.model.fireTableChanged(new TableModelEvent(this.model, row));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        boolean isAdjusting = e.getValueIsAdjusting();
        if (!isAdjusting && !lsm.isSelectionEmpty()) {
            int selectedRow = lsm.getMinSelectionIndex();
            Object o = this.model.getValueAt(selectedRow, 0);
            SelectionEvent se = new SelectionEvent(this, 0);
            se.setSelectedObj((ConsoleObj)o);
            this.fireAdminEventDispatched(se);
        }
    }

    public abstract String[] getColumnHeaders();

    public abstract Object getValueAtCollumn(ConsoleObj var1, int var2);

    class CObjTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -3527022764578800789L;

        CObjTableModel() {
        }

        @Override
        public int getColumnCount() {
            String[] columnNames = TabledInspector.this.getColumnHeaders();
            if (columnNames == null) {
                return -1;
            }
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            ConsoleObj conObj = TabledInspector.this.getConsoleObj();
            int rowcount = 0;
            if (conObj != null) {
                Enumeration<TreeNode> e = conObj.children();
                while (e.hasMoreElements()) {
                    ++rowcount;
                    e.nextElement();
                }
            }
            return rowcount;
        }

        @Override
        public String getColumnName(int col) {
            String[] columnNames = TabledInspector.this.getColumnHeaders();
            if (columnNames == null) {
                return null;
            }
            if (col >= columnNames.length) {
                return null;
            }
            return columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            ConsoleObj conObj = TabledInspector.this.getConsoleObj();
            if (conObj == null) {
                return null;
            }
            int rowcount = 0;
            Enumeration<TreeNode> e = conObj.children();
            while (e.hasMoreElements()) {
                ConsoleObj childNode = (ConsoleObj)e.nextElement();
                if (rowcount == row) {
                    if (col == 0) {
                        return childNode;
                    }
                    return TabledInspector.this.getValueAtCollumn(childNode, col);
                }
                ++rowcount;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }
}

