/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TransactionWork {
    List<TransactionWorkMessage> sentMessages = new ArrayList<TransactionWorkMessage>();
    List<TransactionWorkMessageAck> messageAcknowledgments;

    public void addMessage(TransactionWorkMessage msg) {
        if (this.sentMessages == null) {
            this.sentMessages = new ArrayList<TransactionWorkMessage>();
        }
        this.sentMessages.add(msg);
    }

    public void addMessageAcknowledgement(TransactionWorkMessageAck ack) {
        if (this.messageAcknowledgments == null) {
            this.messageAcknowledgments = new ArrayList<TransactionWorkMessageAck>();
        }
        this.messageAcknowledgments.add(ack);
    }

    public List<TransactionWorkMessage> getSentMessages() {
        return this.sentMessages;
    }

    public void setMessages(List<TransactionWorkMessage> sentMessages) {
        this.sentMessages = sentMessages;
    }

    public List<TransactionWorkMessageAck> getMessageAcknowledgments() {
        return this.messageAcknowledgments;
    }

    public void setMessageAcknowledgments(List<TransactionWorkMessageAck> messageAcknowledgments) {
        this.messageAcknowledgments = messageAcknowledgments;
    }

    public int numSentMessages() {
        if (this.sentMessages == null) {
            return 0;
        }
        return this.sentMessages.size();
    }

    public int numMessageAcknowledgments() {
        if (this.messageAcknowledgments == null) {
            return 0;
        }
        return this.messageAcknowledgments.size();
    }

    public void readWork(DataInputStream dis) throws IOException, BrokerException {
        int numSentMessages = dis.readInt();
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + "readWork numSentMessages=" + numSentMessages);
        }
        ArrayList<TransactionWorkMessage> sentMessages = new ArrayList<TransactionWorkMessage>(numSentMessages);
        for (int i = 0; i < numSentMessages; ++i) {
            TransactionWorkMessage workMessage = new TransactionWorkMessage();
            workMessage.readWork(dis);
            sentMessages.add(workMessage);
        }
        this.setMessages(sentMessages);
        int numConsumedMessages = dis.readInt();
        ArrayList<TransactionWorkMessageAck> consumedMessages = new ArrayList<TransactionWorkMessageAck>(numConsumedMessages);
        for (int i = 0; i < numConsumedMessages; ++i) {
            TransactionWorkMessageAck messageAck = new TransactionWorkMessageAck();
            messageAck.readWork(dis);
            consumedMessages.add(messageAck);
        }
        this.setMessageAcknowledgments(consumedMessages);
    }

    public void writeWork(DataOutputStream dos) throws IOException {
        dos.writeInt(this.numSentMessages());
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " writeWork numSentMessages=" + this.numSentMessages() + " numMessageAcknowledgments=" + this.numMessageAcknowledgments();
            Globals.getLogger().log(4, msg);
        }
        if (this.numSentMessages() > 0) {
            for (TransactionWorkMessage workMessage : this.getSentMessages()) {
                workMessage.writeWork(dos);
            }
        }
        dos.writeInt(this.numMessageAcknowledgments());
        if (this.numMessageAcknowledgments() > 0) {
            for (TransactionWorkMessageAck messageAck : this.getMessageAcknowledgments()) {
                messageAck.writeWork(dos);
            }
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(" num messages ").append(this.numSentMessages());
        s.append(" num acks ").append(this.numMessageAcknowledgments());
        String result = super.toString() + new String(s);
        return result;
    }

    String getPrefix() {
        return "TransactionWork: " + Thread.currentThread().getName();
    }
}

