/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import java.util.HashMap;
import java.util.Map;

public class JavaTypeHelper {
    private static final Map _primitiveToWrappers = new HashMap(9);
    private static final Map _primitiveNamesToPrimitives;
    private static final Map _primitiveNamesToWrapperNames;
    private static final Map _wrapperToPrimitiveNames;

    public static String getPackageName(String className) {
        if (className != null) {
            int index = className.lastIndexOf(46);
            return index != -1 ? className.substring(0, index) : "";
        }
        return null;
    }

    public static String getShortClassName(String className) {
        if (className != null) {
            int index = className.lastIndexOf(46);
            return className.substring(index + 1);
        }
        return null;
    }

    public static Class getWrapperClass(Class primitive) {
        return (Class)_primitiveToWrappers.get(primitive);
    }

    public static Class getPrimitiveClass(String primitiveName) {
        return (Class)_primitiveNamesToPrimitives.get(primitiveName);
    }

    public static String getWrapperName(String primitiveName) {
        return (String)_primitiveNamesToWrapperNames.get(primitiveName);
    }

    public static String getPrimitiveName(Class wrapper) {
        return (String)_wrapperToPrimitiveNames.get(wrapper);
    }

    public static Boolean valueOf(boolean flag) {
        return flag ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        _primitiveToWrappers.put(Boolean.TYPE, Boolean.class);
        _primitiveToWrappers.put(Byte.TYPE, Byte.class);
        _primitiveToWrappers.put(Character.TYPE, Character.class);
        _primitiveToWrappers.put(Double.TYPE, Double.class);
        _primitiveToWrappers.put(Float.TYPE, Float.class);
        _primitiveToWrappers.put(Integer.TYPE, Integer.class);
        _primitiveToWrappers.put(Long.TYPE, Long.class);
        _primitiveToWrappers.put(Short.TYPE, Short.class);
        _primitiveToWrappers.put(Void.TYPE, Void.class);
        _primitiveNamesToPrimitives = new HashMap(9);
        _primitiveNamesToPrimitives.put("boolean", Boolean.TYPE);
        _primitiveNamesToPrimitives.put("byte", Byte.TYPE);
        _primitiveNamesToPrimitives.put("char", Character.TYPE);
        _primitiveNamesToPrimitives.put("double", Double.TYPE);
        _primitiveNamesToPrimitives.put("float", Float.TYPE);
        _primitiveNamesToPrimitives.put("int", Integer.TYPE);
        _primitiveNamesToPrimitives.put("long", Long.TYPE);
        _primitiveNamesToPrimitives.put("short", Short.TYPE);
        _primitiveNamesToPrimitives.put("void", Void.TYPE);
        _primitiveNamesToWrapperNames = new HashMap(9);
        _primitiveNamesToWrapperNames.put("boolean", "Boolean");
        _primitiveNamesToWrapperNames.put("byte", "Byte");
        _primitiveNamesToWrapperNames.put("char", "Character");
        _primitiveNamesToWrapperNames.put("double", "Double");
        _primitiveNamesToWrapperNames.put("float", "Float");
        _primitiveNamesToWrapperNames.put("int", "Integer");
        _primitiveNamesToWrapperNames.put("long", "Long");
        _primitiveNamesToWrapperNames.put("short", "Short");
        _primitiveNamesToWrapperNames.put("void", "Void");
        _wrapperToPrimitiveNames = new HashMap(9);
        _wrapperToPrimitiveNames.put(Boolean.class, "boolean");
        _wrapperToPrimitiveNames.put(Byte.class, "byte");
        _wrapperToPrimitiveNames.put(Character.class, "char");
        _wrapperToPrimitiveNames.put(Double.class, "double");
        _wrapperToPrimitiveNames.put(Float.class, "float");
        _wrapperToPrimitiveNames.put(Integer.class, "int");
        _wrapperToPrimitiveNames.put(Long.class, "long");
        _wrapperToPrimitiveNames.put(Short.class, "short");
        _wrapperToPrimitiveNames.put(Void.class, "void");
    }
}

