/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.managed.forbiddenapi;

import ee.jakarta.tck.concurrent.common.fixed.counter.StaticCounter;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

@Web
@Common(value={Common.PACKAGE.FIXED_COUNTER})
public class ForbiddenAPIServletTests {
    @Resource(lookup="java:comp/DefaultManagedScheduledExecutorService")
    private ManagedScheduledExecutorService scheduledExecutor;

    @Deployment(name="ForbiddenAPIServletTests")
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.create(WebArchive.class);
    }

    @BeforeEach
    protected void before() {
        StaticCounter.reset();
    }

    @Assertion(id="SPEC:56 SPEC:57.1", strategy="Test basic function for ManagedScheduledExecutorService: awaitTermination")
    public void testAwaitTermination() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.scheduledExecutor.awaitTermination(10L, TimeUnit.SECONDS));
    }

    @Assertion(id="SPEC:56 SPEC:57.2", strategy="Test basic function for ManagedScheduledExecutorService: isShutdown")
    public void testIsShutdown() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.scheduledExecutor.isShutdown());
    }

    @Assertion(id="SPEC:56 SPEC:57.3", strategy="Test basic function for ManagedScheduledExecutorService: isTerminated")
    public void testIsTerminated() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.scheduledExecutor.isTerminated());
    }

    @Assertion(id="SPEC:56 SPEC:57.4", strategy="Test basic function for ManagedScheduledExecutorService: shutdown")
    public void testShutdown() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.scheduledExecutor.shutdown());
    }

    @Assertion(id="SPEC:56 SPEC:57.5", strategy="Test basic function for ManagedScheduledExecutorService: shutdownNow")
    public void testShutdownNow() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.scheduledExecutor.shutdownNow());
    }
}

