/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.common.transaction;

import ee.jakarta.tck.concurrent.common.transaction.Connections;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.transaction.UserTransaction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.InitialContext;

public class CancelledTransactedTask
implements Runnable {
    private AtomicBoolean runQuery = new AtomicBoolean(false);
    private AtomicBoolean beginTransaction = new AtomicBoolean(false);
    private AtomicBoolean cancelTransaction = new AtomicBoolean(false);
    private final String sqlTemplate;

    public CancelledTransactedTask(String sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    private void waitForRun() {
        long startTime = System.currentTimeMillis();
        while (!this.runQuery.get()) {
            if (System.currentTimeMillis() > startTime + TestConstants.waitTimeout.toMillis()) {
                throw new RuntimeException("runQuery flag was not set to true before timeout.");
            }
            Wait.sleep(TestConstants.pollInterval);
        }
    }

    @Override
    public void run() {
        try {
            UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
            ut.begin();
            this.beginTransaction.set(true);
            this.waitForRun();
            try (Connection conn = Connections.getConnection(false);
                 PreparedStatement pStmt = conn.prepareStatement(this.sqlTemplate);){
                String sTypeDesc = "Type-Cancelled-99";
                int newType = 991;
                pStmt.setInt(1, newType);
                pStmt.setString(2, sTypeDesc);
                pStmt.executeUpdate();
                if (this.cancelTransaction.get()) {
                    ut.rollback();
                    return;
                }
                ut.commit();
            }
            catch (Exception e) {
                try {
                    ut.rollback();
                }
                catch (Exception sqle) {
                    sqle.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AtomicBoolean getRunQuery() {
        return this.runQuery;
    }

    public AtomicBoolean getBeginTransaction() {
        return this.beginTransaction;
    }

    public AtomicBoolean getCancelTransaction() {
        return this.cancelTransaction;
    }

    public String getSqlTemplate() {
        return this.sqlTemplate;
    }
}

