/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ManagedThreadFactory;

import ee.jakarta.tck.concurrent.common.fixed.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.StaticCounter;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManageableThread;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

@Web
@Common(value={Common.PACKAGE.TASKS, Common.PACKAGE.FIXED_COUNTER})
public class ManagedThreadFactoryTests
extends TestClient {
    @Resource(lookup="java:comp/DefaultManagedThreadFactory")
    private ManagedThreadFactory threadFactory;

    @Deployment(name="APITests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{ManagedThreadFactoryTests.class.getPackage()});
    }

    @Assertion(id="JAVADOC:20 SPEC:99.1", strategy="Lookup default ManagedThreadFactory object and create new thread. Check return value of method isShutdown of new thread.")
    public void isShutdown() {
        ManageableThread m = (ManageableThread)this.threadFactory.newThread((Runnable)new CounterRunnableTask());
        Assertions.assertFalse((boolean)m.isShutdown());
    }

    @Assertion(id="SPEC:83 SPEC:83.1 SPEC:83.2 SPEC:83.3 SPEC:103 SPEC:96.5 SPEC:96.6 SPEC:105 SPEC:96 SPEC:93 SPEC:96.3", strategy="Interrupt thread and ensure the thread did not run.")
    public void interruptThreadApiTest() {
        StaticCounter.reset();
        CounterRunnableTask task = new CounterRunnableTask(TestConstants.pollInterval);
        Thread thread = this.threadFactory.newThread((Runnable)task);
        thread.start();
        thread.interrupt();
        Wait.waitTillThreadFinish(thread);
        Assertions.assertEquals((int)0, (int)StaticCounter.getCount());
    }

    @Assertion(id="SPEC:97;", strategy="Create thread and ensure the thread is an instance of ManageableThread")
    public void implementsManageableThreadInterfaceTest() {
        CounterRunnableTask task = new CounterRunnableTask();
        Thread thread = this.threadFactory.newThread((Runnable)task);
        Assertions.assertTrue((boolean)(thread instanceof ManageableThread), (String)"The thread returned by ManagedThreadFactory should be instance of ManageableThread.");
    }
}

