/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.resourcedef;

import ee.jakarta.tck.concurrent.common.context.providers.IntContextProvider;
import ee.jakarta.tck.concurrent.common.context.providers.StringContextProvider;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionInterface;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionWebBean;
import ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.resourcedef.ManagedThreadFactoryDefinitionOnEJBServlet;
import ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.resourcedef.ManagedThreadFactoryDefinitionServlet;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Web
@RunAsClient
@Common(value={Common.PACKAGE.CONTEXT, Common.PACKAGE.CONTEXT_PROVIDERS})
public class ManagedThreadFactoryDefinitionWebTests
extends TestClient {
    @ArquillianResource(value=ManagedThreadFactoryDefinitionServlet.class)
    private URL baseURL;
    @ArquillianResource(value=ManagedThreadFactoryDefinitionOnEJBServlet.class)
    private URL ejbContextURL;
    @TestName
    private String testname;

    @Deployment(name="ManagedThreadFactoryDefinitionTests")
    public static WebArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ManagedThreadFactoryDefinitionTests_web.war")).addPackages(false, new Package[]{ManagedThreadFactoryDefinitionWebTests.class.getPackage()})).addClasses(new Class[]{ContextServiceDefinitionInterface.class, ContextServiceDefinitionWebBean.class, ContextServiceDefinitionServlet.class})).addAsWebInfResource(ManagedThreadFactoryDefinitionWebTests.class.getPackage(), "web.xml", "web.xml")).addAsWebInfResource(ManagedThreadFactoryDefinitionWebTests.class.getPackage(), "ejb-jar.xml", "ejb-jar.xml")).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()});
        return war;
    }

    @Override
    protected String getServletPath() {
        return "ManagedThreadFactoryDefinitionServlet";
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/226", version="3.0.0")
    @Assertion(id="GIT:156", strategy="ManagedThreadFactoryDefinition with all attributes configured")
    public void testManagedThreadFactoryDefinitionAllAttributes() throws Throwable {
        this.runTest(this.baseURL, this.testname);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/226", version="3.0.0")
    @Assertion(id="GIT:156", strategy="A ManagedThreadFactoryDefinition defined on an EJB with all attributes configured enforces priority and propagates context.")
    public void testManagedThreadFactoryDefinitionAllAttributesEJB() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ManagedThreadFactoryDefinitionOnEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:156", strategy="ManagedThreadFactoryDefinition with minimal attributes configured")
    public void testManagedThreadFactoryDefinitionDefaults() throws Throwable {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:156", strategy="ManagedThreadFactoryDefinition defined on an EJB with minimal attributes creates threads with normal priority and uses java:comp/DefaultContextService to determine context propagation and clearing")
    public void testManagedThreadFactoryDefinitionDefaultsEJB() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ManagedThreadFactoryDefinitionOnEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/226", version="3.0.0")
    @Assertion(id="GIT:156", strategy="ManagedThreadFactory can be supplied to a ForkJoinPool, which manages thread context and priority as configured")
    public void testParallelStreamBackedByManagedThreadFactory() throws Throwable {
        this.runTest(this.baseURL, this.testname);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/226", version="3.0.0")
    @Assertion(id="GIT:156", strategy="ManagedThreadFactoryDefinition defined on an EJB is supplied to a ForkJoinPool and uses java:comp/DefaultContextService to determine context propagation and priority.")
    public void testParallelStreamBackedByManagedThreadFactoryEJB() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ManagedThreadFactoryDefinitionOnEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }
}

