/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.Schedule;
import jakarta.enterprise.context.ApplicationScoped;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

@ApplicationScoped
public class AppBean {
    private static final Logger log = Logger.getLogger(AppBean.class.getCanonicalName());
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);

    @Asynchronous(executor="java:module/concurrent/ExecutorB")
    public CompletionStage<String> addStringContextAndWait(BlockingQueue<String> queue, CountDownLatch blocker) {
        String s = StringContext.get();
        try {
            queue.add(s);
            blocker.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            return Asynchronous.Result.complete((Object)s);
        }
        catch (Exception x) {
            throw new CompletionException(x);
        }
    }

    @Asynchronous
    public void exchange(Exchanger<String> exchanger, String value) {
        try {
            exchanger.exchange(value, MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException x) {
            throw new CompletionException(x);
        }
    }

    @Asynchronous(executor="java:app/concurrent/ExecutorA")
    public CompletableFuture<Integer> waitAndGetIntContext(Semaphore started, CountDownLatch blocker) {
        started.release(1);
        CompletableFuture future = Asynchronous.Result.getFuture();
        try {
            while (!future.isDone() && !blocker.await(300L, TimeUnit.MILLISECONDS)) {
                System.out.println(Thread.currentThread().getName() + ": waitAndGetIntContext awaiting signal from caller");
            }
            future.complete(IntContext.get());
        }
        catch (Exception x) {
            future.completeExceptionally(x);
        }
        return future;
    }

    @Asynchronous(runAt={@Schedule(cron="*/5 * * * * *")})
    public CompletableFuture<Integer> scheduledEvery5seconds(int runs, RETURN type, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery5seconds method " + count + "/" + runs + " (Returning: " + type.toString() + ")");
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            return null;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        switch (type) {
            case NULL: {
                return null;
            }
            case COMPLETE_EXCEPTIONALLY: {
                future.completeExceptionally(new Exception(type.getMessage()));
                break;
            }
            case COMPLETE_RESULT: {
                future.complete(count);
                break;
            }
            case INCOMPLETE: {
                break;
            }
            case THROW_EXCEPTION: {
                throw new RuntimeException(type.getMessage());
            }
        }
        return future;
    }

    @Asynchronous(runAt={@Schedule(cron="*/3 * * * * *")})
    public void scheduledEvery3SecondsVoidReturn(int runs, RETURN type, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery3SecondsVoidReturn method " + count + "/" + runs + " (Returning: " + type.toString() + ")");
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            return;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        switch (type) {
            case COMPLETE_EXCEPTIONALLY: {
                future.completeExceptionally(new Exception(type.getMessage()));
                break;
            }
            case COMPLETE_RESULT: {
                future.complete(null);
                break;
            }
            case THROW_EXCEPTION: {
                throw new RuntimeException(type.getMessage());
            }
        }
    }

    @Asynchronous(runAt={@Schedule(cron="*/3 * * * * *")})
    public CompletableFuture<Integer> scheduledEvery3SecondsTakes5Seconds(int runs, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery3SecondsTakes5Seconds method " + count + "/" + runs);
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            try {
                Thread.sleep(Duration.ofSeconds(5L).toMillis());
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread was interrupted while waiting", e);
            }
            return null;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        future.complete(count);
        return future;
    }

    @Asynchronous(executor="java:module/concurrent/ExecutorB", runAt={@Schedule(cron="*/3 * * * * *")})
    public CompletableFuture<Integer> scheduledEvery3Seconds(int runs, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery3Seconds method " + count + "/" + runs);
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            return null;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        future.complete(IntContext.get());
        return future;
    }

    @Asynchronous(executor="java:module/concurrent/ExecutorB", runAt={@Schedule(cron="*/3 * * * * *"), @Schedule(cron="0 * * * * *")})
    public CompletableFuture<String> scheduledEvery3SecondsAnd1Minute(int runs, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery3SecondsAnd1Minute method " + count + "/" + runs);
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            return null;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        future.complete(StringContext.get());
        return future;
    }

    @Asynchronous(executor="java:app/concurrent/INVALID", runAt={@Schedule(cron="*/3 * * * * *")})
    public CompletableFuture<String> scheduledInvalidExecutor() {
        throw new UnsupportedOperationException("Should not be able to execute with invalid executor");
    }

    public static enum RETURN {
        NULL,
        COMPLETE_EXCEPTIONALLY,
        COMPLETE_RESULT,
        INCOMPLETE,
        THROW_EXCEPTION;

        private String message = "";

        public RETURN withMessage(String m) {
            this.message = m;
            return this;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

