/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.LastExecution;

import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.Trigger;
import java.lang.reflect.Method;
import java.util.Date;

public class LogicDrivenTrigger
implements Trigger {
    private static final TestLogger log = TestLogger.get(LogicDrivenTrigger.class);
    private long delta;
    private String testName;
    private boolean moreThanTwice = false;
    private Date startTime;
    private static final long TIME_COMPARE_INACCURACY = 2000L;
    public static final int RIGHT_COUNT = 2;
    public static final int WRONG_COUNT = 1;

    public LogicDrivenTrigger(long delta, String testName) {
        this.delta = delta;
        this.testName = testName;
        this.startTime = new Date();
    }

    private String getErrStr4NotEqual(Object expected, Object real) {
        String result = this.testName + "failed, ";
        result = result + "expected " + expected + ",";
        result = result + "but got " + real;
        return result;
    }

    private boolean validateDateTimeEquals(Date time1, Date time2) {
        long diff = time1.getTime() - time2.getTime();
        return Math.abs(diff) < 2000L;
    }

    public Date getNextRunTime(LastExecution lastExecutionInfo, Date taskScheduledTime) {
        if (lastExecutionInfo == null) {
            return new Date();
        }
        if (this.moreThanTwice) {
            return null;
        }
        try {
            Method testMethod = this.getClass().getMethod(this.testName, LastExecution.class, Date.class);
            return (Date)testMethod.invoke((Object)this, lastExecutionInfo, taskScheduledTime);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not run test", e);
        }
    }

    public Date lastExecutionGetIdentityNameTest(LastExecution lastExecutionInfo, Date taskScheduledTime) {
        if (!"lastExecutionGetIdentityNameTest".equals(lastExecutionInfo.getIdentityName())) {
            log.warning(this.getErrStr4NotEqual("lastExecutionGetIdentityNameTest", lastExecutionInfo.getIdentityName()));
            return null;
        }
        this.moreThanTwice = true;
        return new Date(new Date().getTime() + this.delta);
    }

    public Date lastExecutionGetResultRunnableTest(LastExecution lastExecutionInfo, Date taskScheduledTime) {
        if (lastExecutionInfo.getResult() != null) {
            log.warning(this.getErrStr4NotEqual(null, lastExecutionInfo.getResult()));
            return null;
        }
        this.moreThanTwice = true;
        return new Date(new Date().getTime() + this.delta);
    }

    public Date lastExecutionGetResultCallableTest(LastExecution lastExecutionInfo, Date taskScheduledTime) {
        if (!Integer.valueOf(1).equals(lastExecutionInfo.getResult())) {
            log.warning(this.getErrStr4NotEqual(1, lastExecutionInfo.getResult()));
            return null;
        }
        this.moreThanTwice = true;
        return new Date(new Date().getTime() + this.delta);
    }

    public Date lastExecutionGetRunningTimeTest(LastExecution lastExecutionInfo, Date taskScheduledTime) {
        if (!this.validateDateTimeEquals(this.startTime, lastExecutionInfo.getScheduledStart())) {
            log.warning(this.getErrStr4NotEqual(this.startTime, lastExecutionInfo.getScheduledStart()));
            return null;
        }
        if (lastExecutionInfo.getScheduledStart().getTime() > lastExecutionInfo.getRunStart().getTime()) {
            log.warning(this.testName + "failed, getRunStart time should not be earlier than getScheduledStart");
            return null;
        }
        if (lastExecutionInfo.getRunEnd().getTime() - lastExecutionInfo.getRunStart().getTime() < TestConstants.pollInterval.toMillis()) {
            log.warning(this.testName + "failed, the difference between getRunEnd and getRunStart is shorter than the real running time");
            return null;
        }
        this.moreThanTwice = true;
        return new Date(new Date().getTime() + this.delta);
    }

    public boolean skipRun(LastExecution lastExecutionInfo, Date scheduledRunTime) {
        return false;
    }
}

