/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate_servlet;

import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate_servlet.ProxyCreatorServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate_servlet.WorkInterfaceServlet;
import java.net.URL;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class ContextPropagationServletTests
extends TestClient {
    private static final String APP_NAME_PROXY = "ContextPropagationServletTests.Proxy";
    private static final String APP_NAME_WORK = "ContextPropagationServletTests.Work";
    private static final String APP_NAME_DESERIALIZE = "ContextPropagationServletTests.Deserialize";
    @ArquillianResource
    @OperateOnDeployment(value="ContextPropagationServletTests.Proxy")
    URL baseURL;
    @ArquillianResource
    @OperateOnDeployment(value="ContextPropagationServletTests.Work")
    URL workInterfaceURL;

    @Deployment(name="ContextPropagationServletTests.Proxy", testable=false)
    public static WebArchive createDeployment1() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ContextPropagationServletTests.Proxy.war")).addPackages(true, new Package[]{ContextPropagationServletTests.getFrameworkPackage(), ContextPropagationServletTests.class.getPackage()})).deleteClass(WorkInterfaceServlet.class)).addAsWebInfResource(ContextPropagationServletTests.class.getPackage(), "web.xml", "web.xml");
    }

    @Deployment(name="ContextPropagationServletTests.Work", testable=false)
    public static WebArchive createDeployment2() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ContextPropagationServletTests.Work.war")).addPackages(true, new Package[]{ContextPropagationServletTests.getFrameworkPackage(), ContextPropagationServletTests.class.getPackage()})).deleteClass(ProxyCreatorServlet.class);
    }

    @Deployment(name="ContextPropagationServletTests.Deserialize", testable=false)
    public static WebArchive createDeployment3() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ContextPropagationServletTests.Deserialize.war")).addPackages(true, new Package[]{ContextPropagationServletTests.getFrameworkPackage(), ContextPropagationServletTests.class.getPackage()})).deleteClasses(new Class[]{ProxyCreatorServlet.class, WorkInterfaceServlet.class});
    }

    @Override
    protected String getServletPath() {
        return "ProxyCreatorServlet";
    }

    @Test
    public void testJNDIContextInServlet() {
        URL proxyURL = URLBuilder.get().withBaseURL(this.workInterfaceURL).withPaths("WorkInterfaceServlet").build();
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.baseURL).withPaths(this.getServletPath()).withTestName(this.testName);
        Properties props = new Properties();
        props.put("proxyURL", proxyURL.toString());
        props.put("testMethod", this.testName);
        String resp = this.runTestWithResponse(requestURL, props);
        this.assertNotNull("Response should not be null", resp);
        this.assertStringInResponse(this.testName + " failed to get correct result.", "JNDIContextWeb", resp.trim());
    }

    @Test
    public void testClassloaderInServlet() {
        URL proxyURL = URLBuilder.get().withBaseURL(this.workInterfaceURL).withPaths("WorkInterfaceServlet").build();
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.baseURL).withPaths(this.getServletPath()).withTestName(this.testName);
        Properties props = new Properties();
        props.put("proxyURL", proxyURL.toString());
        props.put("testMethod", this.testName);
        String resp = this.runTestWithResponse(requestURL, props);
        this.assertNotNull("Response should not be null", resp);
        this.assertStringInResponse(this.testName + " failed to get correct result.", "ConcurrentResultOkay", resp.trim());
    }
}

