/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate;

import ee.jakarta.tck.concurrent.framework.EJBJNDIProvider;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ClassloaderServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextEJBProvider;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionBean;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionFromEJBServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.JNDIServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.JSPSecurityServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.SecurityServlet;
import ee.jakarta.tck.concurrent.spi.context.IntContextProvider;
import ee.jakarta.tck.concurrent.spi.context.StringContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

@Test(groups={"eeweb"})
public class ContextPropagationWebTests
extends TestClient {
    @ArquillianResource(value=JNDIServlet.class)
    URL jndiURL;
    @ArquillianResource(value=JSPSecurityServlet.class)
    URL jspURL;
    @ArquillianResource(value=ClassloaderServlet.class)
    URL classloaderURL;
    @ArquillianResource(value=SecurityServlet.class)
    URL securityURL;
    @ArquillianResource(value=ContextServiceDefinitionServlet.class)
    URL contextURL;
    @ArquillianResource(value=ContextServiceDefinitionFromEJBServlet.class)
    URL ejbContextURL;

    @Deployment(name="ContextPropagationTests", testable=false)
    public static WebArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ContextPropagationTests_web.war")).addPackages(true, new Package[]{ContextPropagationWebTests.class.getPackage(), ContextPropagationWebTests.getFrameworkPackage(), ContextPropagationWebTests.getContextPackage(), ContextPropagationWebTests.getContextProvidersPackage()})).deleteClasses(new Class[]{ContextServiceDefinitionBean.class})).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()})).addAsServiceProvider(EJBJNDIProvider.class, new Class[]{ContextEJBProvider.WebProvider.class})).addAsWebInfResource(ContextPropagationWebTests.class.getPackage(), "web.xml", "web.xml")).addAsWebResource(ContextPropagationWebTests.class.getPackage(), "jspTests.jsp", "jspTests.jsp");
        return war;
    }

    @Test(enabled=false)
    public void testSecurityClearedContext() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jspURL).withPaths("jspTests.jsp").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test(enabled=false)
    public void testSecurityUnchangedContext() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jspURL).withPaths("jspTests.jsp").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testSecurityPropagatedContext() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jspURL).withPaths("jspTests.jsp").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testJNDIContextAndCreateProxyInServlet() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jndiURL).withPaths("JNDIServlet").withTestName(this.testName);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testName + "failed to get correct result.", "JNDIContextWeb", resp);
    }

    @Test(enabled=false)
    public void testJNDIContextAndCreateProxyInEJB() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jndiURL).withPaths("JNDIServlet").withTestName(this.testName);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testName + "failed to get correct result.", "JNDIContextEJB", resp);
    }

    @Test
    public void testClassloaderAndCreateProxyInServlet() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.securityURL).withPaths("ClassloaderServlet").withTestName(this.testName);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testName + "failed to get correct result.", "ConcurrentResultOkay", resp);
    }

    @Test
    public void testSecurityAndCreateProxyInServlet() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.classloaderURL).withPaths("SecurityServlet").withTestName(this.testName);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testName + "failed to get correct result.", "ConcurrentResultOkay", resp);
    }

    @Test
    public void testContextServiceDefinitionAllAttributes() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextServiceDefinitionFromEJBAllAttributes() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ContextServiceDefinitionFromEJBServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextServiceDefinitionDefaults() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextServiceDefinitionFromEJBDefaults() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ContextServiceDefinitionFromEJBServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextServiceDefinitionWithThirdPartyContext() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextualConsumer() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test(enabled=false)
    public void testContextualFunction() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextualSupplier() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
        requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ContextServiceDefinitionFromEJBServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testCopyWithContextCapture() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }
}

