/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.groups.ConvertGroup;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.ContainerElementTypeDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.metadata.BasicChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.MetaDataTestUtil;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ContainerElementTypeDescriptorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ContainerElementTypeDescriptorTest.webArchiveBuilder().withTestClassPackage(ContainerElementTypeDescriptorTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="c"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="d")})
    public void testGetContainerElementMetaDataForRoles() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(EmployeeImpl.class, "roles");
        Set containerElementTypeDescriptors = descriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)containerElementTypeDescriptors.size(), (int)2);
        ContainerElementTypeDescriptor iterableContainerElementTypeDescriptor = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypeDescriptors, Iterable.class, 0);
        Assert.assertEquals((Object)iterableContainerElementTypeDescriptor.getElementClass(), String.class);
        MetaDataTestUtil.assertConstraintDescriptors(iterableContainerElementTypeDescriptor.getConstraintDescriptors(), NotNull.class);
        Assert.assertEquals((int)iterableContainerElementTypeDescriptor.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertFalse((boolean)iterableContainerElementTypeDescriptor.isCascaded());
        Assert.assertEquals((int)iterableContainerElementTypeDescriptor.getGroupConversions().size(), (int)0);
        ContainerElementTypeDescriptor setContainerElementTypeDescriptor = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypeDescriptors, Set.class, 0);
        Assert.assertEquals((Object)setContainerElementTypeDescriptor.getElementClass(), String.class);
        MetaDataTestUtil.assertConstraintDescriptors(setContainerElementTypeDescriptor.getConstraintDescriptors(), NotBlank.class, NotEmpty.class);
        Assert.assertEquals((int)setContainerElementTypeDescriptor.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertFalse((boolean)setContainerElementTypeDescriptor.isCascaded());
        Assert.assertEquals((int)setContainerElementTypeDescriptor.getGroupConversions().size(), (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="c"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="d")})
    public void testGetContainerElementMetaDataForDivision() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(EmployeeImpl.class, "division");
        Set containerElementTypeDescriptors = descriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)containerElementTypeDescriptors.size(), (int)1);
        ContainerElementTypeDescriptor iterableContainerElementTypeDescriptor = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypeDescriptors, Optional.class, 0);
        Assert.assertEquals((Object)iterableContainerElementTypeDescriptor.getElementClass(), String.class);
        MetaDataTestUtil.assertConstraintDescriptors(iterableContainerElementTypeDescriptor.getConstraintDescriptors(), NotBlank.class);
        Assert.assertEquals((int)iterableContainerElementTypeDescriptor.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertFalse((boolean)iterableContainerElementTypeDescriptor.isCascaded());
        Assert.assertEquals((int)iterableContainerElementTypeDescriptor.getGroupConversions().size(), (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="c"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="d")})
    public void testGetContainerElementMetaDataForColleagues() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(EmployeeImpl.class, "colleagues");
        Set containerElementTypeDescriptors = descriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)containerElementTypeDescriptors.size(), (int)1);
        ContainerElementTypeDescriptor iterableContainerElementTypeDescriptor = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypeDescriptors, Set.class, 0);
        Assert.assertEquals((Object)iterableContainerElementTypeDescriptor.getElementClass(), Employee.class);
        Assert.assertEquals((int)iterableContainerElementTypeDescriptor.getConstraintDescriptors().size(), (int)0);
        Assert.assertEquals((int)iterableContainerElementTypeDescriptor.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertTrue((boolean)iterableContainerElementTypeDescriptor.isCascaded());
        Assert.assertEquals((int)iterableContainerElementTypeDescriptor.getGroupConversions().size(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="c"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="d")})
    public void testGetContainerElementMetaDataForAddresses() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(EmployeeImpl.class, "addresses");
        Set containerElementTypeDescriptors = descriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)containerElementTypeDescriptors.size(), (int)2);
        ContainerElementTypeDescriptor mapKeyContainerElementTypeDescriptor = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypeDescriptors, Map.class, 0);
        Assert.assertEquals((Object)mapKeyContainerElementTypeDescriptor.getElementClass(), String.class);
        MetaDataTestUtil.assertConstraintDescriptors(mapKeyContainerElementTypeDescriptor.getConstraintDescriptors(), NotNull.class);
        Assert.assertEquals((int)mapKeyContainerElementTypeDescriptor.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertFalse((boolean)mapKeyContainerElementTypeDescriptor.isCascaded());
        Assert.assertEquals((int)mapKeyContainerElementTypeDescriptor.getGroupConversions().size(), (int)0);
        ContainerElementTypeDescriptor mapValueContainerElementTypeDescriptor = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypeDescriptors, Map.class, 1);
        Assert.assertEquals((Object)mapValueContainerElementTypeDescriptor.getElementClass(), List.class);
        MetaDataTestUtil.assertConstraintDescriptors(mapValueContainerElementTypeDescriptor.getConstraintDescriptors(), NotEmpty.class);
        Assert.assertEquals((int)mapValueContainerElementTypeDescriptor.getConstrainedContainerElementTypes().size(), (int)1);
        Assert.assertFalse((boolean)mapValueContainerElementTypeDescriptor.isCascaded());
        Assert.assertEquals((int)mapValueContainerElementTypeDescriptor.getGroupConversions().size(), (int)0);
        Set nestedMapValueContainerElementTypeDescriptors = mapValueContainerElementTypeDescriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)nestedMapValueContainerElementTypeDescriptors.size(), (int)1);
        ContainerElementTypeDescriptor addressContainerElementTypeDescriptor = MetaDataTestUtil.getContainerElementDescriptor(nestedMapValueContainerElementTypeDescriptors, List.class, 0);
        Assert.assertEquals((Object)addressContainerElementTypeDescriptor.getElementClass(), Address.class);
        MetaDataTestUtil.assertConstraintDescriptors(addressContainerElementTypeDescriptor.getConstraintDescriptors(), NotNull.class, ValidAddress.class);
        Assert.assertEquals((int)addressContainerElementTypeDescriptor.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertTrue((boolean)addressContainerElementTypeDescriptor.isCascaded());
        Assert.assertEquals((int)addressContainerElementTypeDescriptor.getGroupConversions().size(), (int)0);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-containerdescriptor", id="b")
    public void testGetContainerElementMetaDataIfNotAContainerElement() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(EmployeeImpl.class, "intern");
        Set containerElementTypeDescriptors = descriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)containerElementTypeDescriptors.size(), (int)0);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-containerdescriptor", id="b")
    public void testGetContainerElementMetaDataForContainerElementWithoutConstraintAndValid() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(EmployeeImpl.class, "zoneId");
        Set containerElementTypeDescriptors = descriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)containerElementTypeDescriptors.size(), (int)0);
    }

    public class EmployeeImpl
    implements Employee {
        @Override
        public Roles getRoles() {
            return null;
        }

        @Override
        public Map<String, List<@ValidAddress Address>> getAddresses() {
            return null;
        }

        @Override
        public Set<Employee> getColleagues() {
            return null;
        }

        @Override
        public Optional<String> getDivision() {
            return null;
        }

        @AssertFalse
        public boolean isIntern() {
            return false;
        }

        @NotNull
        public Optional<ZoneId> getZoneId() {
            return Optional.of(ZoneId.systemDefault());
        }
    }

    public static interface Employee
    extends Person {
        @Override
        public Set<@NotEmpty String> getRoles();

        public Map<@NotNull String, @NotEmpty List<@NotNull @Valid Address>> getAddresses();

        public Set<@Valid @ConvertGroup(from=Default.class, to=BasicChecks.class) Employee> getColleagues();

        public Optional<@NotBlank String> getDivision();
    }

    public static interface Address {
    }

    @Documented
    @Constraint(validatedBy={ValidAddressValidator.class})
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValidAddress {
        public String message() default "{org.hibernate.beanvalidation.tck.tests.metadata..ValidAddress.message}";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class ValidAddressValidator
    implements ConstraintValidator<ValidAddress, Address> {
        public boolean isValid(Address value, ConstraintValidatorContext context) {
            return true;
        }
    }

    public class Roles
    extends HashSet<String> {
    }

    public static interface Person
    extends LegalEntity {
        public Set<@NotBlank String> getRoles();
    }

    public static interface LegalEntity {
        public Iterable<@NotNull String> getRoles();
    }
}

