/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.ChildrenDescriptorCollector;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizardFactory;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.ui.view.swt.reference.CreateNewModelElementStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.EClassSelectionStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceServiceCustomizationVendor;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceStrategyUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emfforms.bazaar.Bazaar;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.bazaar.Vendor;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.bazaar.BazaarUtil;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="DefaultCreateNewModelElementStrategyProvider", property={"service.ranking:Integer=1"}, service={CreateNewModelElementStrategy.Provider.class, DefaultCreateNewModelElementStrategyProvider.class})
public class DefaultCreateNewModelElementStrategyProvider
extends ReferenceServiceCustomizationVendor<CreateNewModelElementStrategy>
implements CreateNewModelElementStrategy.Provider {
    private final Bazaar<EClassSelectionStrategy> eclassSelectionStrategyBazaar = BazaarUtil.createBazaar((Object)EClassSelectionStrategy.NULL);
    private ComponentContext context;
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addEClassSelectionStrategyProvider(EClassSelectionStrategy.Provider provider) {
        this.eclassSelectionStrategyBazaar.addVendor((Vendor)provider);
    }

    public void removeEClassSelectionStrategyProvider(EClassSelectionStrategy.Provider provider) {
        this.eclassSelectionStrategyBazaar.removeVendor((Vendor)provider);
    }

    @Reference
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Activate
    void activate(ComponentContext context) {
        this.context = context;
    }

    @Deactivate
    void deactivate() {
        this.context = null;
    }

    @Override
    protected boolean handles(EObject owner, EReference reference) {
        return true;
    }

    @Create
    public CreateNewModelElementStrategy createCreateNewModelElementStrategy() {
        EClassSelectionStrategy classSelectionStrategy = ReferenceStrategyUtil.createDynamicEClassSelectionStrategy(this.eclassSelectionStrategyBazaar, this.context);
        return new DefaultStrategy(classSelectionStrategy);
    }

    public Map<EClass, EObject> getNewObjectsByDescriptors(EObject owner, EReference reference) {
        Collection<CommandParameter> descriptors = this.getNewChildDescriptors(owner, reference);
        if (descriptors.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<EClass, EObject> result = new LinkedHashMap<EClass, EObject>();
        for (CommandParameter next : descriptors) {
            EObject object = next.getEValue();
            result.put(object.eClass(), object);
        }
        return result;
    }

    private Collection<CommandParameter> getNewChildDescriptors(EObject owner, EReference reference) {
        Collection descriptors = new ChildrenDescriptorCollector().getDescriptors(owner);
        EClass referenceType = reference.getEReferenceType();
        ArrayList<CommandParameter> result = new ArrayList<CommandParameter>(descriptors.size());
        for (Object next : descriptors) {
            CommandParameter newChild;
            if (!(next instanceof CommandParameter) || !referenceType.isInstance((Object)(newChild = (CommandParameter)next).getEValue())) continue;
            result.add(newChild);
        }
        return result;
    }

    private class DefaultStrategy
    implements CreateNewModelElementStrategy {
        private final EClassSelectionStrategy classSelectionStrategy;

        DefaultStrategy(EClassSelectionStrategy classSelectionStrategy) {
            this.classSelectionStrategy = classSelectionStrategy;
        }

        @Override
        public Optional<EObject> createNewModelElement(EObject owner, EReference reference) {
            Map<EClass, EObject> availableChildren = DefaultCreateNewModelElementStrategyProvider.this.getNewObjectsByDescriptors(owner, reference);
            Collection<Object> availableClasses = availableChildren.isEmpty() ? EMFUtils.getSubClasses((EClass)reference.getEReferenceType()) : availableChildren.keySet();
            Collection<EClass> classes = this.classSelectionStrategy.collectEClasses(owner, reference, availableClasses);
            if (classes.isEmpty()) {
                String errorMessage = String.format("No concrete classes for the type %1$s were found!", reference.getEReferenceType().getName());
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)errorMessage);
                DefaultCreateNewModelElementStrategyProvider.this.reportService.report(new AbstractReport(errorMessage));
                return Optional.empty();
            }
            if (classes.size() == 1) {
                EClass only = classes.iterator().next();
                EObject result = availableChildren.get(only);
                if (result == null) {
                    result = EcoreUtil.create((EClass)only);
                }
                return Optional.of((Object)result);
            }
            return Optional.ofNullable((Object)this.getModelElementInstanceFromList(classes, availableChildren));
        }

        private EObject getModelElementInstanceFromList(Collection<EClass> classes, Map<EClass, EObject> availableChildren) {
            EObject fromAvailable;
            SelectionComposite helper = CompositeFactory.getSelectModelClassComposite(new HashSet(), new HashSet(), classes);
            EObject result = SelectModelElementWizardFactory.openCreateNewModelElementDialog((SelectionComposite)helper);
            if (result != null && (fromAvailable = availableChildren.get(result.eClass())) != null) {
                result = fromAvailable;
            }
            return result;
        }
    }
}

