/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.spi;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;

public final class EMFUtils {
    private EMFUtils() {
    }

    public static Collection<EClass> getSubClasses(EClass superClass) {
        HashSet<EClass> classes = new HashSet<EClass>();
        for (EPackage ePackage : EMFUtils.getAllRegisteredEPackages()) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || eClass.isInterface() || EcorePackage.eINSTANCE.getEObject() != superClass && !superClass.isSuperTypeOf(eClass)) continue;
                classes.add(eClass);
            }
        }
        return classes;
    }

    public static Set<EPackage> getAllRegisteredEPackages() {
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        LinkedHashSet namespaceURIs = new LinkedHashSet(EPackage.Registry.INSTANCE.keySet());
        for (String nsURI : namespaceURIs) {
            EPackage ePackage;
            try {
                ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            }
            catch (Exception ex) {
                continue;
            }
            if (ePackage == null) continue;
            ePackages.add(ePackage);
        }
        return ePackages;
    }
}

