/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.section.swt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.section.model.VSection;
import org.eclipse.emf.ecp.view.spi.section.model.VSectionPackage;
import org.eclipse.emf.ecp.view.spi.section.swt.AbstractSectionSWTRenderer;
import org.eclipse.emf.ecp.view.spi.section.swt.ExpandableCompositeTooltipProperty;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SectionNodeSWTRenderer
extends AbstractSectionSWTRenderer {
    private Set<AbstractSectionSWTRenderer> childRenderers;
    private SWTGridDescription rendererGridDescription;
    private ModelChangeListener listener;
    private ExpandableComposite expandableComposite;

    @Inject
    public SectionNodeSWTRenderer(VSection vElement, ViewModelContext viewContext, ReportService reportService, VTViewTemplateProvider viewTemplateProvider) {
        super(vElement, viewContext, reportService, viewTemplateProvider);
    }

    protected void preInit() {
        super.preInit();
        this.listener = new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getRawNotification().isTouch()) {
                    return;
                }
                if (notification.getNotifier() != SectionNodeSWTRenderer.this.getVElement()) {
                    return;
                }
                if (notification.getStructuralFeature() == VSectionPackage.eINSTANCE.getSection_Collapsed()) {
                    SectionNodeSWTRenderer.this.handleCollapseState();
                }
            }
        };
        this.getViewModelContext().registerViewChangeListener(this.listener);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        int selfColumns;
        this.rendererGridDescription = new SWTGridDescription();
        this.childRenderers = new LinkedHashSet<AbstractSectionSWTRenderer>();
        ArrayList<SWTGridDescription> childGridDescriptions = new ArrayList<SWTGridDescription>();
        for (VSection item : ((VSection)this.getVElement()).getChildItems()) {
            AbstractSWTRenderer itemRenderer;
            try {
                itemRenderer = this.getEMFFormsRendererFactory().getRendererInstance((VElement)item, this.getViewModelContext());
            }
            catch (EMFFormsNoRendererException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                continue;
            }
            SWTGridDescription itemGridDescription = itemRenderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            this.childRenderers.add((AbstractSectionSWTRenderer)itemRenderer);
            childGridDescriptions.add(itemGridDescription);
        }
        int columns = selfColumns = 1 + ((VSection)this.getVElement()).getChildren().size();
        for (SWTGridDescription childGridDescription : childGridDescriptions) {
            int n = columns = childGridDescription.getColumns() > columns ? childGridDescription.getColumns() : columns;
        }
        this.rendererGridDescription.setColumns(columns);
        ArrayList<SWTGridCell> gridCells = new ArrayList<SWTGridCell>();
        int emptyCellColumnIndicator = -1;
        int row = 0;
        Optional<Integer> labelWidth = this.getLabelWidth();
        Point prefSize = labelWidth.isPresent() ? new Point(((Integer)labelWidth.get()).intValue(), -1) : new Point(-1, -1);
        int curSelfColumn = 0;
        gridCells.add(this.createGridCell(row, curSelfColumn++, this, prefSize));
        int emptyColumns = columns - selfColumns;
        int i = 0;
        while (i < emptyColumns) {
            gridCells.add(this.createGridCell(row, emptyCellColumnIndicator--, this));
            ++i;
        }
        int columnToAdd = 0;
        while (columnToAdd < ((VSection)this.getVElement()).getChildren().size()) {
            gridCells.add(this.createGridCell(row, curSelfColumn++, this));
            ++columnToAdd;
        }
        ++row;
        for (SWTGridDescription childGridDescription : childGridDescriptions) {
            SWTGridCell[][] sortedChildGridCells;
            SWTGridCell[][] sWTGridCellArray = sortedChildGridCells = this.getArrangedChildGridCells(childGridDescription, columns);
            int n = sortedChildGridCells.length;
            int n2 = 0;
            while (n2 < n) {
                SWTGridCell[] rowGridCells = sWTGridCellArray[n2];
                int currentRow = rowGridCells[0].getRow() + row;
                AbstractSWTRenderer renderer = (AbstractSWTRenderer)rowGridCells[0].getRenderer();
                int i2 = 0;
                while (i2 < rowGridCells.length) {
                    SWTGridCell swtGridCell = rowGridCells[i2];
                    if (swtGridCell != null) {
                        gridCells.add(this.createGridCell(currentRow, swtGridCell.getColumn(), (AbstractSWTRenderer<? extends VElement>)((AbstractSWTRenderer)swtGridCell.getRenderer()), swtGridCell.getPreferredSize()));
                    } else {
                        gridCells.add(this.createGridCell(currentRow, emptyCellColumnIndicator--, (AbstractSWTRenderer<? extends VElement>)renderer));
                    }
                    ++i2;
                }
                ++n2;
            }
            row += childGridDescription.getRows();
        }
        this.rendererGridDescription.setRows(row);
        this.rendererGridDescription.setGrid(gridCells);
        return this.rendererGridDescription;
    }

    private SWTGridCell[][] getArrangedChildGridCells(SWTGridDescription childGridDescription, int columns) {
        SWTGridCell[][] result = new SWTGridCell[childGridDescription.getRows()][columns];
        for (SWTGridCell swtGridCell : childGridDescription.getGrid()) {
            if (swtGridCell.getColumn() < 0) continue;
            result[swtGridCell.getRow()][swtGridCell.getColumn()] = swtGridCell;
        }
        SWTGridCell[][] sWTGridCellArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            SWTGridCell[] columnArray = sWTGridCellArray[n2];
            SectionNodeSWTRenderer.shiftElementsToEndOfArrayButFirstElement(columnArray);
            ++n2;
        }
        return result;
    }

    private static void shiftElementsToEndOfArrayButFirstElement(SWTGridCell[] columnArray) {
        int length = columnArray.length;
        int i = length - 1;
        while (i >= 0) {
            int index;
            if (columnArray[i] == null) {
                index = SectionNodeSWTRenderer.getIndexToMove(columnArray, i);
                if (index == -1) {
                    return;
                }
            } else {
                return;
            }
            columnArray[i] = columnArray[index];
            columnArray[index] = null;
            --i;
        }
    }

    private static int getIndexToMove(SWTGridCell[] columnArray, int index) {
        int i = index - 1;
        while (i > 0) {
            if (columnArray[i] != null) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private SWTGridCell createGridCell(int row, int column, AbstractSWTRenderer<? extends VElement> renderer) {
        SWTGridCell gridCell = new SWTGridCell(row, column, renderer);
        gridCell.setVerticalFill(false);
        gridCell.setVerticalGrab(false);
        if (column == 3) {
            gridCell.setHorizontalGrab(true);
        } else {
            gridCell.setHorizontalGrab(false);
        }
        return gridCell;
    }

    private SWTGridCell createGridCell(int row, int column, AbstractSWTRenderer<? extends VElement> renderer, Point prefSize) {
        SWTGridCell gridCell = this.createGridCell(row, column, renderer);
        gridCell.setPreferredSize(prefSize);
        return gridCell;
    }

    @Override
    protected Control createFirstColumn(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(this.computeLeftMargin(), 0, 0, 0).applyTo(composite);
        this.setExpandableComposite(new ExpandableComposite(composite, 0, 2));
        this.getExpandableComposite().setExpanded(!((VSection)this.getVElement()).isCollapsed());
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getVElement());
        IObservableValue modelLabelValue = EMFEditObservables.observeValue((EditingDomain)editingDomain, (EObject)this.getVElement(), (EStructuralFeature)VViewPackage.eINSTANCE.getElement_Label());
        String text = "text";
        WritableValue value = new WritableValue((Object)"text", String.class);
        IObservableValue textObservable = PojoProperties.value(ExpandableComposite.class, (String)"text", String.class).observe((Object)this.expandableComposite);
        this.getDataBindingContext().bindValue(textObservable, modelLabelValue);
        this.initExpandableComposite(this.getExpandableComposite());
        IObservableValue modelTooltipValue = EMFEditObservables.observeValue((EditingDomain)editingDomain, (EObject)this.getVElement(), (EStructuralFeature)VViewPackage.eINSTANCE.getHasTooltip_Tooltip());
        ISWTObservableValue targetTooltipValue = new ExpandableCompositeTooltipProperty().observe((Widget)this.getExpandableComposite());
        this.getDataBindingContext().bindValue((IObservableValue)targetTooltipValue, modelTooltipValue);
        return composite;
    }

    private void initExpandableComposite(ExpandableComposite expandableComposite) {
        expandableComposite.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                ((VSection)SectionNodeSWTRenderer.this.getVElement()).setCollapsed(!e.getState());
            }
        });
    }

    @Override
    protected void adjustLayoutData(boolean vis) {
        super.adjustLayoutData(vis);
        for (AbstractSectionSWTRenderer childRenderer : this.childRenderers) {
            boolean visible = vis;
            if (((VSection)this.getVElement()).isCollapsed()) {
                visible = false;
            }
            childRenderer.adjustLayoutData(visible);
        }
    }

    protected void applyEnable() {
        this.getExpandableComposite().setEnabled(((VSection)this.getVElement()).isEffectivelyEnabled());
    }

    @Override
    protected void dispose() {
        this.getViewModelContext().unregisterViewChangeListener(this.listener);
        super.dispose();
    }

    @Override
    protected void initCollapseState() {
        Iterator iterator = this.getControls().values().iterator();
        while (iterator.hasNext()) {
            GridData gridData;
            Control control = (Control)iterator.next();
            int width = control.getSize().x;
            Object layoutData = control.getLayoutData();
            if (!GridData.class.isInstance(layoutData) || (gridData = (GridData)layoutData) == null) continue;
            gridData.widthHint = width;
            if (iterator.hasNext()) continue;
            gridData.grabExcessHorizontalSpace = true;
        }
        this.handleCollapseState();
    }

    private void handleCollapseState() {
        for (AbstractSectionSWTRenderer childRenderer : this.childRenderers) {
            childRenderer.adjustLayoutData(!((VSection)this.getVElement()).isCollapsed());
        }
        ((Control)this.getControls().values().iterator().next()).getParent().layout(false);
        this.getExpandableComposite().setExpanded(!((VSection)this.getVElement()).isCollapsed());
    }

    protected ExpandableComposite getExpandableComposite() {
        return this.expandableComposite;
    }

    protected void setExpandableComposite(ExpandableComposite expandableComposite) {
        this.expandableComposite = expandableComposite;
    }
}

