/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.spi;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BidirectionalMap<K, V> {
    private final Map<K, V> keyToValues = new LinkedHashMap();
    private final Map<V, K> valuesToKeys = new LinkedHashMap<V, K>();

    public void put(K key, V value) {
        this.keyToValues.put(key, value);
        this.valuesToKeys.put(value, key);
    }

    public synchronized V removeByKey(K key) {
        V v = this.keyToValues.get(key);
        this.keyToValues.remove(key);
        this.valuesToKeys.remove(v);
        return v;
    }

    public synchronized K removeByValue(V value) {
        K k = this.valuesToKeys.get(value);
        this.valuesToKeys.remove(value);
        this.keyToValues.remove(k);
        return k;
    }

    public V getValue(K key) {
        return this.keyToValues.get(key);
    }

    public K getByValue(V value) {
        return this.valuesToKeys.get(value);
    }

    public Set<K> keys() {
        LinkedHashSet<K> linkedHashSet = new LinkedHashSet<K>();
        linkedHashSet.addAll(this.keyToValues.keySet());
        return linkedHashSet;
    }

    public Set<V> values() {
        LinkedHashSet<V> linkedHashSet = new LinkedHashSet<V>();
        linkedHashSet.addAll(this.valuesToKeys.keySet());
        return linkedHashSet;
    }
}

