/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.swt;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Display;

public class RunnableManager {
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicBoolean isPending = new AtomicBoolean(false);
    private final Display display;

    public RunnableManager(Display display) {
        this.display = display;
    }

    private void finish(Runnable runnable) {
        this.isRunning.compareAndSet(true, false);
        if (this.isPending.compareAndSet(true, false)) {
            this.executeAsync(runnable);
        }
    }

    private Runnable createWrapperRunnable(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    RunnableManager.this.finish(runnable);
                }
            }
        };
    }

    public void executeAsync(Runnable runnable) {
        if (this.isRunning.compareAndSet(false, true)) {
            this.getDisplay().asyncExec(this.createWrapperRunnable(runnable));
        } else {
            this.isPending.compareAndSet(false, true);
        }
    }

    public synchronized Display getDisplay() {
        return this.display;
    }
}

