/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.annotation.EAnnotationItemProviderAdapterFactory;

class AnnotationItemProviderAdapterFactoryRegistryReader
extends RegistryReader {
    static final String TAG_FACTORY = "factory";
    static final String ATT_URI = "uri";
    static final String ATT_CLASS = "class";

    public AnnotationItemProviderAdapterFactoryRegistryReader() {
        super(RegistryFactory.getRegistry(), EcoreEditPlugin.INSTANCE.getSymbolicName(), "annotation_item_provider_adapter_factory");
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_FACTORY)) {
            String uri = element.getAttribute(ATT_URI);
            if (uri == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    AnnotationItemProviderAdapterFactoryDescriptor previous = EAnnotationItemProviderAdapterFactory.Registry.INSTANCE.put(uri, new AnnotationItemProviderAdapterFactoryDescriptor(element, uri, ATT_CLASS));
                    if (previous instanceof AnnotationItemProviderAdapterFactoryDescriptor) {
                        AnnotationItemProviderAdapterFactoryDescriptor descriptor = previous;
                        EcorePlugin.INSTANCE.log((Object)("Both '" + descriptor.getElement().getContributor().getName() + "' and '" + element.getContributor().getName() + "' register an annotation item provider adapter factory for '" + uri + "'"));
                    }
                    return true;
                }
                EAnnotationItemProviderAdapterFactory.Registry.INSTANCE.remove(uri);
                return true;
            }
        }
        return false;
    }

    static class AnnotationItemProviderAdapterFactoryDescriptor
    extends RegistryReader.PluginClassDescriptor
    implements EAnnotationItemProviderAdapterFactory.Factory {
        private String uri;

        public AnnotationItemProviderAdapterFactoryDescriptor(IConfigurationElement e, String uri, String attrName) {
            super(e, attrName);
            this.uri = uri;
        }

        public EAnnotationItemProviderAdapterFactory createEAnnotationItemProviderAdapterFactory() {
            try {
                Class javaClass = CommonPlugin.loadClass((String)this.element.getDeclaringExtension().getContributor().getName(), (String)this.element.getAttribute(this.attributeName));
                try {
                    Constructor defaultConstructor = javaClass.getConstructor(new Class[0]);
                    return (EAnnotationItemProviderAdapterFactory)((Object)defaultConstructor.newInstance(new Object[0]));
                }
                catch (NoSuchMethodException e) {
                    try {
                        Constructor annotationSourceConstructor = javaClass.getConstructor(String.class);
                        return (EAnnotationItemProviderAdapterFactory)((Object)annotationSourceConstructor.newInstance(this.uri));
                    }
                    catch (NoSuchMethodException nestedException) {
                        throw new WrappedException((Exception)e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new WrappedException((Exception)e);
            }
            catch (SecurityException e) {
                throw new WrappedException((Exception)e);
            }
            catch (InstantiationException e) {
                throw new WrappedException((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new WrappedException((Exception)e);
            }
            catch (IllegalArgumentException e) {
                throw new WrappedException((Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new WrappedException((Exception)e);
            }
        }

        public IConfigurationElement getElement() {
            return this.element;
        }
    }
}

