/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MojoExecution {
    private Plugin plugin;
    private String goal;
    private String executionId;
    private MojoDescriptor mojoDescriptor;
    private Xpp3Dom configuration;
    private Source source = Source.LIFECYCLE;
    private String lifecyclePhase;
    private Map<String, List<MojoExecution>> forkedExecutions = new LinkedHashMap<String, List<MojoExecution>>();

    public MojoExecution(Plugin plugin, String goal, String executionId) {
        this.plugin = plugin;
        this.goal = goal;
        this.executionId = executionId;
    }

    public MojoExecution(MojoDescriptor mojoDescriptor) {
        this.mojoDescriptor = mojoDescriptor;
        this.executionId = null;
        this.configuration = null;
    }

    public MojoExecution(MojoDescriptor mojoDescriptor, String executionId, Source source) {
        this.mojoDescriptor = mojoDescriptor;
        this.executionId = executionId;
        this.configuration = null;
        this.source = source;
    }

    public MojoExecution(MojoDescriptor mojoDescriptor, String executionId) {
        this.mojoDescriptor = mojoDescriptor;
        this.executionId = executionId;
        this.configuration = null;
    }

    public MojoExecution(MojoDescriptor mojoDescriptor, Xpp3Dom configuration) {
        this.mojoDescriptor = mojoDescriptor;
        this.configuration = configuration;
        this.executionId = null;
    }

    public Source getSource() {
        return this.source;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public Plugin getPlugin() {
        if (this.mojoDescriptor != null) {
            return this.mojoDescriptor.getPluginDescriptor().getPlugin();
        }
        return this.plugin;
    }

    public MojoDescriptor getMojoDescriptor() {
        return this.mojoDescriptor;
    }

    public Xpp3Dom getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Xpp3Dom configuration) {
        this.configuration = configuration;
    }

    public String identify() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.executionId);
        sb.append(this.configuration.toString());
        return sb.toString();
    }

    public String getLifecyclePhase() {
        return this.lifecyclePhase;
    }

    public void setLifecyclePhase(String lifecyclePhase) {
        this.lifecyclePhase = lifecyclePhase;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        if (this.mojoDescriptor != null) {
            buffer.append(this.mojoDescriptor.getId());
        }
        buffer.append(" {execution: ").append(this.executionId).append('}');
        return buffer.toString();
    }

    public String getGroupId() {
        if (this.mojoDescriptor != null) {
            return this.mojoDescriptor.getPluginDescriptor().getGroupId();
        }
        return this.plugin.getGroupId();
    }

    public String getArtifactId() {
        if (this.mojoDescriptor != null) {
            return this.mojoDescriptor.getPluginDescriptor().getArtifactId();
        }
        return this.plugin.getArtifactId();
    }

    public String getVersion() {
        if (this.mojoDescriptor != null) {
            return this.mojoDescriptor.getPluginDescriptor().getVersion();
        }
        return this.plugin.getVersion();
    }

    public String getGoal() {
        if (this.mojoDescriptor != null) {
            return this.mojoDescriptor.getGoal();
        }
        return this.goal;
    }

    public void setMojoDescriptor(MojoDescriptor mojoDescriptor) {
        this.mojoDescriptor = mojoDescriptor;
    }

    public Map<String, List<MojoExecution>> getForkedExecutions() {
        return this.forkedExecutions;
    }

    public void setForkedExecutions(String projectKey, List<MojoExecution> forkedExecutions) {
        this.forkedExecutions.put(projectKey, forkedExecutions);
    }

    public static enum Source {
        CLI,
        LIFECYCLE;

    }
}

