/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.exporter;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.xmlpivot.common.predicates.EMFPredicates;
import org.polarsys.capella.xmlpivot.exporter.ExportEngine;

public abstract class AbstractExporter {
    private final ExportEngine exportEngine;

    public AbstractExporter(ExportEngine engine) {
        this.exportEngine = engine;
    }

    public ExportEngine getExportEngine() {
        return this.exportEngine;
    }

    public Collection<EObject> export(Collection<? extends EObject> sourceObjects, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.doCopyObjects(sourceObjects, (IProgressMonitor)subMonitor.newChild(50));
        this.getExportEngine().copyReferences();
        subMonitor.worked(40);
        Collection result = Collections2.filter(this.getExportEngine().values(), (Predicate)EMFPredicates.isRootContainer());
        subMonitor.worked(10);
        return result;
    }

    protected abstract void doCopyObjects(Collection<? extends EObject> var1, IProgressMonitor var2);
}

