/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.test;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.model.semantic.SimplifiedCapellaMetadata;
import org.polarsys.capella.xmlpivot.common.CapellaPackageRegistry;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class SimplifiedM2ConsistencyTest
extends TestCase {
    private final SimplifiedCapellaMetadata meta = SimplifiedCapellaMetadata.INSTANCE;

    public void testNonSemanticTypesOfNavigableFeatures() {
        HashSet<String> result = new HashSet<String>();
        TreeIterator it = EcoreUtil.getAllContents((Collection)CapellaPackageRegistry.getAllCapellaPackages());
        while (it.hasNext()) {
            EStructuralFeature feature;
            EObject next = (EObject)it.next();
            if (!(next instanceof EStructuralFeature) || !this.meta.isNavigable(feature = (EStructuralFeature)next)) continue;
            if (feature instanceof EReference) {
                if (this.meta.isSemantic(feature.getEType())) continue;
                result.add(String.valueOf(feature.getEType().getEPackage().getName()) + "." + feature.getEType().getName());
                continue;
            }
            if (this.meta.isSemantic((EClassifier)((EAttribute)feature).getEAttributeType())) continue;
            result.add(String.valueOf(feature.getEType().getEPackage().getName()) + "." + feature.getEType().getName());
        }
        SimplifiedM2ConsistencyTest.assertEquals((String)Joiner.on((String)System.getProperty("line.separator")).join(result), (int)0, (int)result.size());
    }

    public void testNonSemanticClassesWithNavigableFeatures() {
        Collection<String> abstrAct = this.getNonSemanticClassesWithNavigableFeatures((Predicate<EClass>)Predicates.alwaysTrue());
        SimplifiedM2ConsistencyTest.assertEquals((String)Joiner.on((String)System.getProperty("line.separator")).join(abstrAct), (int)0, (int)abstrAct.size());
    }

    public void testOrphanedSemanticClassifiers() {
        HashSet<Object> navigableFeatures = new HashSet<Object>();
        HashSet<EClassifier> semanticClassifiers = new HashSet<EClassifier>();
        TreeIterator it = EcoreUtil.getAllContents((Collection)CapellaPackageRegistry.getAllCapellaPackages());
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (next instanceof EClassifier && this.meta.isSemantic((EClassifier)next)) {
                semanticClassifiers.add((EClassifier)next);
            }
            if (!(next instanceof EStructuralFeature) || !this.meta.isNavigable((EStructuralFeature)next)) continue;
            if (next instanceof EReference) {
                if (!this.meta.isContainment((EReference)next)) continue;
                navigableFeatures.add((EReference)next);
                continue;
            }
            navigableFeatures.add((EStructuralFeature)next);
        }
        ArrayList<String> orphaned = new ArrayList<String>();
        block1: for (EClassifier c : semanticClassifiers) {
            if (c == CapellamodellerPackage.Literals.PROJECT || c == EmdePackage.Literals.EXTENSIBLE_ELEMENT || c == EmdePackage.Literals.ELEMENT || c == CapellamodellerPackage.Literals.LIBRARY) continue;
            for (EStructuralFeature eStructuralFeature : navigableFeatures) {
                EClass type;
                if (!(c instanceof EClass) ? eStructuralFeature instanceof EAttribute && ((EAttribute)eStructuralFeature).getEAttributeType() == c : eStructuralFeature instanceof EReference && (type = ((EReference)eStructuralFeature).getEReferenceType()).isSuperTypeOf((EClass)c)) continue block1;
            }
            orphaned.add(String.valueOf(c.getEPackage().getName()) + "." + c.getName());
        }
        SimplifiedM2ConsistencyTest.assertEquals((String)Joiner.on((String)System.getProperty("line.separator")).join(orphaned), (int)0, (int)orphaned.size());
    }

    public void testNoOppositeEReferences() {
        ArrayList withOpposite = new ArrayList();
        TreeIterator it = EcoreUtil.getAllContents((Collection)CapellaPackageRegistry.getAllCapellaPackages());
        while (it.hasNext()) {
            EReference nextRef;
            EObject next = (EObject)it.next();
            if (!(next instanceof EReference) || (nextRef = (EReference)next).getEOpposite() == null || withOpposite.contains(nextRef.getEOpposite()) || nextRef.isDerived() || nextRef.getEOpposite().isDerived()) continue;
            System.err.println("Opposite references: " + nextRef.getEContainingClass().getName() + "." + nextRef.getName() + "<----->" + nextRef.getEOpposite().getEContainingClass().getName() + "." + nextRef.getEOpposite().getName());
        }
        SimplifiedM2ConsistencyTest.assertTrue((boolean)withOpposite.isEmpty());
    }

    private Collection<String> getNonSemanticClassesWithNavigableFeatures(Predicate<EClass> predicate) {
        HashSet<String> result = new HashSet<String>();
        TreeIterator it = EcoreUtil.getAllContents((Collection)CapellaPackageRegistry.getAllCapellaPackages());
        while (it.hasNext()) {
            EStructuralFeature feature;
            EObject next = (EObject)it.next();
            if (!(next instanceof EStructuralFeature) || !this.meta.isNavigable(feature = (EStructuralFeature)next) || !predicate.apply((Object)feature.getEContainingClass()) || this.meta.isSemantic((EClassifier)feature.getEContainingClass())) continue;
            result.add(String.valueOf(feature.getEContainingClass().getEPackage().getName()) + "." + feature.getEContainingClass().getName());
        }
        return result;
    }
}

