/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternParameter;

public class ParameterMatcher {
    private final Pattern called;
    private final Pattern caller;
    private Map<PatternParameter, PatternParameter> matching;

    public boolean matches() {
        if (this.matching == null) {
            this.matching = new HashMap<PatternParameter, PatternParameter>();
            PatternParameter match = null;
            for (PatternParameter sParam : this.called.getAllParameters()) {
                String type = sParam.getType();
                for (PatternParameter tParam : this.caller.getAllParameters()) {
                    if (!type.equals(tParam.getType())) continue;
                    if (match == null) {
                        match = tParam;
                        continue;
                    }
                    this.matching.clear();
                    return false;
                }
                if (match == null) {
                    this.matching.clear();
                    return false;
                }
                this.matching.put(sParam, match);
                match = null;
            }
        }
        if (this.called.getAllParameters().isEmpty() && this.caller.getAllParameters().isEmpty()) {
            return true;
        }
        return !this.matching.isEmpty();
    }

    public Map<PatternParameter, PatternParameter> getMatching() {
        if (this.matching == null) {
            throw new IllegalStateException();
        }
        return this.matching;
    }

    private ParameterMatcher(Pattern caller, Pattern called) {
        this.called = called;
        this.caller = caller;
    }

    public static boolean matches(Pattern caller, Pattern called) {
        return ParameterMatcher.create(called, caller).matches();
    }

    public static ParameterMatcher create(Pattern caller, Pattern called) {
        return new ParameterMatcher(caller, called);
    }
}

