/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.execution;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.egf.model.pattern.Node;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternOutputProcessor;
import org.eclipse.egf.model.pattern.PatternRuntimeException;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.execution.InternalPatternContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputManager {
    private static final Method LOOP_METHOD_ON_NODE;
    private static final Method EXECUTION_METHOD_ON_NODE;
    private static final Method LOOP_METHOD_ON_BUFFER;
    private static final Method EXECUTION_METHOD_ON_BUFFER;

    static {
        try {
            LOOP_METHOD_ON_NODE = PatternOutputProcessor.class.getMethod("applyOnLoopResult", Node.Container.class);
            EXECUTION_METHOD_ON_NODE = PatternOutputProcessor.class.getMethod("applyOnExecutionResult", Node.Container.class);
            LOOP_METHOD_ON_BUFFER = PatternOutputProcessor.class.getMethod("applyOnLoopResult", StringBuilder.class);
            EXECUTION_METHOD_ON_BUFFER = PatternOutputProcessor.class.getMethod("applyOnExecutionResult", StringBuilder.class);
        }
        catch (NoSuchMethodException e) {
            EGFPatternPlugin.getDefault().logError("Cannot find required methods on PatternOutputProcessor class", e);
            throw new IllegalStateException();
        }
    }

    public static String getHierarchy(Node node) {
        StringBuilder builder = new StringBuilder();
        OutputManager.getHierarchy(builder, node, 0);
        return builder.toString();
    }

    public static void getHierarchy(StringBuilder builder, Node node, int nb) {
        int n = 0;
        while (n < nb) {
            builder.append('\t');
            ++n;
        }
        builder.append("[").append(node.getPatternClass()).append("] > \n");
        ++nb;
        if (node instanceof Node.Container) {
            Node.Container container = (Node.Container)node;
            for (Node node1 : container.getChildren()) {
                OutputManager.getHierarchy(builder, node1, nb);
            }
            return;
        }
        if (node instanceof Node.Leaf) {
            Node.Leaf leaf = (Node.Leaf)node;
            leaf.toString(builder);
            builder.append("\n");
        }
    }

    private static void doFlatten(StringBuilder builder, Node node, boolean deep) {
        if (!deep && node instanceof Node.CallBackContainer) {
            return;
        }
        if (node instanceof Node.Container) {
            Node.Container container = (Node.Container)node;
            for (Node node1 : container.getChildren()) {
                OutputManager.doFlatten(builder, node1, deep);
            }
            return;
        }
        if (node instanceof Node.Leaf) {
            Node.Leaf leaf = (Node.Leaf)node;
            leaf.toString(builder);
            return;
        }
        throw new IllegalStateException();
    }

    public static String computeExecutionOutput(PatternContext ctx) {
        StringBuilder builder = new StringBuilder();
        Node.Container node = ((InternalPatternContext)ctx).getNode();
        OutputManager.applyProcessors(ctx, EXECUTION_METHOD_ON_NODE, node, node);
        OutputManager.doFlatten(builder, (Node)node, true);
        OutputManager.applyProcessors(ctx, EXECUTION_METHOD_ON_BUFFER, node, builder);
        return builder.toString();
    }

    public static String computeLoopOutput(PatternContext ctx) {
        StringBuilder builder = new StringBuilder();
        Node.Container node = ((InternalPatternContext)ctx).getNode();
        OutputManager.applyProcessors(ctx, LOOP_METHOD_ON_NODE, node, node);
        OutputManager.doFlatten(builder, (Node)node, true);
        OutputManager.applyProcessors(ctx, LOOP_METHOD_ON_BUFFER, node, builder);
        return builder.toString();
    }

    public static String computeLoopOutputWithoutCallback(PatternContext ctx) {
        StringBuilder builder = new StringBuilder();
        OutputManager.doFlatten(builder, (Node)((InternalPatternContext)ctx).getNode(), false);
        return builder.toString();
    }

    protected static void applyProcessors(PatternContext ctx, Method method, Node.Container node, Object parameter) {
        try {
            for (PatternOutputProcessor defaultProcessor : OutputManager.getDefaultProcessors()) {
                String processorId = String.valueOf(defaultProcessor.getProcessorId()) + ':' + parameter.getClass().getName();
                if (node.getAppliedOutputProcessors().contains(processorId)) continue;
                method.invoke((Object)defaultProcessor, parameter);
            }
            PatternOutputProcessor processor = (PatternOutputProcessor)ctx.getValue("pattern.output.processor");
            if (processor != null && !node.getAppliedOutputProcessors().contains(String.valueOf(processor.getProcessorId()) + ':' + parameter.getClass().getName())) {
                method.invoke((Object)processor, parameter);
            }
        }
        catch (Exception e) {
            throw new PatternRuntimeException((Throwable)e);
        }
    }

    private static List<PatternOutputProcessor> getDefaultProcessors() throws CoreException {
        ArrayList<PatternOutputProcessor> result = new ArrayList<PatternOutputProcessor>();
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.egf.model.trace.output.processor");
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    result.add((PatternOutputProcessor)element.createExecutableExtension("class"));
                    ++n4;
                }
                ++n2;
            }
        }
        return result;
    }
}

