/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.trace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.egf.core.trace.Category;
import org.eclipse.egf.core.trace.Configuration;
import org.eclipse.egf.core.trace.Filter;
import org.eclipse.egf.model.pattern.Node;
import org.eclipse.egf.pattern.trace.TracePreferencesManager;

public class TraceHelper {
    public static final String DEFAULT_TRACE_PROCESSOR_ID = "default.trace.processor";
    public static final TracePreferencesManager PREFERENCES = new TracePreferencesManager();
    private final Map<Pattern, String> patterns;
    private final boolean enable;

    private TraceHelper(boolean enable) {
        this.enable = enable;
        this.patterns = null;
    }

    private TraceHelper(Configuration configuration) {
        this.enable = true;
        this.patterns = new LinkedHashMap<Pattern, String>();
        for (Category cat : configuration.getCategories()) {
            if (!cat.isActive()) continue;
            for (Filter filter : cat.getFilters()) {
                String pattern = filter.getPattern();
                if (pattern == null) continue;
                Pattern compile = Pattern.compile(pattern);
                this.patterns.put(compile, filter.getComment());
            }
        }
    }

    private void addTrace(Node.DataLeaf node) {
        if (!this.enable) {
            return;
        }
        Node.Container parent = (Node.Container)node.getParent();
        if (parent == null) {
            return;
        }
        int index = parent.getChildren().indexOf(node);
        String cls = node.getPatternClass();
        String comment = this.getComment2use(cls);
        if (comment != null) {
            String method;
            if ("".equals(comment)) {
                comment = "[{}]";
            }
            if ((method = node.getMethod()) != null) {
                cls = String.valueOf(cls) + ":" + method;
            }
            String startComment = null;
            String endComment = null;
            if (comment.contains("{}")) {
                int indexOf = comment.indexOf("{}");
                String begin = comment.substring(0, indexOf);
                String end = comment.substring(indexOf + 2);
                startComment = String.valueOf(begin) + "begin of pattern '" + cls + "'" + end;
                endComment = String.valueOf(begin) + "end of pattern '" + cls + "'" + end;
            } else {
                startComment = String.valueOf(comment) + "begin of pattern '" + cls;
                endComment = String.valueOf(comment) + "end of pattern '" + cls + "'";
            }
            TraceNode previous = new TraceNode(parent, startComment);
            TraceNode next = new TraceNode(parent, endComment);
            parent.getChildren().add(index, previous);
            parent.getChildren().add(index + 2, next);
        }
    }

    private String getComment2use(String cls) {
        if (this.patterns == null) {
            return "";
        }
        for (Map.Entry<Pattern, String> entry : this.patterns.entrySet()) {
            Pattern p = entry.getKey();
            if (!p.matcher(cls).matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    private void process(Node node) {
        node.getAppliedOutputProcessors().add(DEFAULT_TRACE_PROCESSOR_ID);
        String patternClass = node.getPatternClass();
        if (patternClass != null && node instanceof Node.DataLeaf) {
            this.addTrace((Node.DataLeaf)node);
        }
    }

    public void apply(Node.Container node) {
        if (!this.enable || node.getAppliedOutputProcessors().contains(DEFAULT_TRACE_PROCESSOR_ID)) {
            return;
        }
        this.process((Node)node);
        for (Node child : new ArrayList(node.getChildren())) {
            if (child instanceof Node.Container) {
                this.apply((Node.Container)child);
                continue;
            }
            this.process(child);
        }
    }

    public static TraceHelper createInstance() throws IOException {
        switch (PREFERENCES.loadState()) {
            case ALWAYS: {
                return new TraceHelper(true);
            }
            case FILTERS: {
                return new TraceHelper(PREFERENCES.loadConfiguration());
            }
        }
        return new TraceHelper(false);
    }

    public static class TraceNode
    extends Node.Leaf {
        private final String message;

        public TraceNode(Node.Container parent, String message) {
            super(parent, null);
            this.message = message;
        }

        public String toString() {
            return "Trace [msg=" + this.message + "]";
        }

        public void toString(StringBuilder builder) {
            builder.append(this.message).append("\n");
        }
    }
}

