/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.docgen.util.CapellaServices;

public class FunctionHelper {
    public static Collection<String> getInvolvingFunctionalChains(String projectName, String outputFolder, AbstractFunction function) {
        ArrayList<String> functionalChains = new ArrayList<String>();
        for (FunctionalChain involvingFunctionalChain : function.getInvolvingFunctionalChains()) {
            functionalChains.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)involvingFunctionalChain));
        }
        return functionalChains;
    }

    public static Collection<String> getAllocatingComponents(String projectName, String outputFolder, AbstractFunction function) {
        ArrayList<String> allocatingComponents = new ArrayList<String>();
        for (EObject componentAllocation : function.getComponentFunctionalAllocations()) {
            EObject component = componentAllocation.eContainer();
            allocatingComponents.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, component));
        }
        return allocatingComponents;
    }

    public static String getAllocatingComponentExchangess(String projectName, String outputFolder, FunctionalExchange functionalExchange) {
        StringBuilder allocatingComponents = new StringBuilder();
        if (!functionalExchange.getAllocatingComponentExchanges().isEmpty()) {
            allocatingComponents.append("<ul class=\"generatedList\">");
            for (EObject componentExchange : functionalExchange.getAllocatingComponentExchanges()) {
                allocatingComponents.append("<li>");
                allocatingComponents.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, componentExchange));
                allocatingComponents.append("</li>");
            }
            allocatingComponents.append("</ul>");
        }
        return allocatingComponents.toString();
    }

    public static String getInvolvingFunctionalChains(String projectName, String outputFolder, FunctionalExchange functionalExchange) {
        StringBuilder involvingFunctionalChainsString = new StringBuilder();
        if (!functionalExchange.getInvolvingFunctionalChains().isEmpty()) {
            involvingFunctionalChainsString.append("<ul class=\"generatedList\">");
            for (EObject involvingFunctionalChain : functionalExchange.getInvolvingFunctionalChains()) {
                involvingFunctionalChainsString.append("<li>");
                involvingFunctionalChainsString.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, involvingFunctionalChain));
                involvingFunctionalChainsString.append("</li>");
            }
            involvingFunctionalChainsString.append("</ul>");
        }
        return involvingFunctionalChainsString.toString();
    }

    public static String getExchangedItems(FunctionalExchange functionalExchange, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        EList abstractExchangeItems = functionalExchange.getExchangedItems();
        if (abstractExchangeItems.size() > 0) {
            sb.append("<ul class=\"generatedList\">");
            for (AbstractExchangeItem currentItem : abstractExchangeItems) {
                sb.append("<li>");
                sb.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)currentItem));
                sb.append("</li>");
            }
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public static String getRealizedFunctionalExchanges(FunctionalExchange functionalExchange, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        EList realizedFunctionalExchanges = functionalExchange.getRealizedFunctionalExchanges();
        if (!realizedFunctionalExchanges.isEmpty()) {
            sb.append("<ul class=\"generatedList\">");
            for (FunctionalExchange exchange : realizedFunctionalExchanges) {
                sb.append("<li>");
                sb.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)exchange));
                sb.append("</li>");
            }
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public static String getRealizingFunctionalExchanges(FunctionalExchange functionalExchange, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        EList realizingFunctionalExchanges = functionalExchange.getRealizingFunctionalExchanges();
        if (!realizingFunctionalExchanges.isEmpty()) {
            sb.append("<ul class=\"generatedList\">");
            for (FunctionalExchange exchange : realizingFunctionalExchanges) {
                sb.append("<li>");
                sb.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)exchange));
                sb.append("</li>");
            }
            sb.append("</ul>");
        }
        return sb.toString();
    }
}

