/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;
import org.polarsys.capella.docgen.Activator;

public class ImageHelper {
    public static ImageHelper INSTANCE = new ImageHelper();
    private static final String ICON_FOLDER_NAME = "icon";
    private static final String FILE_NOT_FOUND = "Image source file doesn't exist";
    private static final String FOLDER_HIERARCHY_CREATION_ERROR = "Cannot Create Target Folder Hierarchy";
    private static final NullProgressMonitor MONITOR = new NullProgressMonitor();
    private static final String PNG = "png";
    private static final String FILES_SUFFIX = "_files";
    public static final String DATA_IMAGE_PREFIX = "data:image/";
    public static final String DOC_GEN_GENERATED = "_gen_";
    private static final String BASE64_POSTFIX = ";base64";
    private static final String ERROR_IMAGE_DATA_FORMAT = "Error while interpreting image data format: {0}";
    private static final String ERROR_IMAGE_DATA_WRITE = "Error while writing image data to file: {0}";

    private ImageHelper() {
    }

    public void copyProjectImageToSystemLocation(String srcFile, String targetFile) throws IOException {
        File inputFile = new File(srcFile);
        File outputFile = new File(targetFile);
        this.createFoldersHierarchy(outputFile);
        if (inputFile.exists()) {
            this.copyFile(inputFile, outputFile);
            this.manageSpecialFiles(inputFile.getAbsolutePath(), outputFile.getAbsolutePath(), ".html", ".htm");
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen", "Image source file doesn't exist: \"" + inputFile.getAbsolutePath() + "\""));
        }
    }

    private void manageSpecialFiles(String srcFile, String targetFile, String ... extensions) throws IOException {
        List<String> extensionList = Arrays.asList(extensions);
        String srcExtension = srcFile.substring(srcFile.lastIndexOf(46));
        if (srcExtension != null && extensionList.contains(srcExtension.toLowerCase())) {
            String companionFolderPath = srcFile.substring(0, srcFile.lastIndexOf(46));
            File companionFolder = new File(companionFolderPath);
            if (companionFolder.exists()) {
                this.doCopy(targetFile, companionFolder, "");
            } else {
                companionFolder = new File(companionFolderPath = String.valueOf(companionFolderPath) + FILES_SUFFIX);
                if (companionFolder.exists()) {
                    companionFolder = new File(companionFolderPath);
                    this.doCopy(targetFile, companionFolder, FILES_SUFFIX);
                }
            }
        }
    }

    private void doCopy(String targetFile, File companionFolder, String suffix) throws IOException {
        File destFolder = new File(String.valueOf(targetFile.substring(0, targetFile.lastIndexOf(46))) + suffix);
        this.doCopy(companionFolder, destFolder);
    }

    private void createFoldersHierarchy(File outputFile) {
        File parentFile = outputFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen", "Cannot Create Target Folder Hierarchy: \"" + outputFile.getAbsolutePath() + "\""));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(File sourceFile, File destFile) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileInputStream inputStr = new FileInputStream(sourceFile);
            try {
                try (FileOutputStream outputStr = new FileOutputStream(destFile);){
                    int bytesRead;
                    byte[] buf = new byte[1024];
                    while ((bytesRead = ((InputStream)inputStr).read(buf)) > 0) {
                        ((OutputStream)outputStr).write(buf, 0, bytesRead);
                    }
                }
                if (inputStr == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStr == null) throw throwable;
                ((InputStream)inputStr).close();
                throw throwable;
            }
            ((InputStream)inputStr).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void doCopy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            String[] stringArray = files = src.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                this.doCopy(srcFile, destFile);
                ++n2;
            }
        } else {
            this.copyFile(src, dest);
        }
    }

    public static String getTypePng(EObject eObject, String projectName, String folderName) {
        ImageDescriptor imageDescriptor = CapellaUIResourcesPlugin.getDefault().getPNGImage(eObject);
        Image image = null;
        if (imageDescriptor != null) {
            image = imageDescriptor.createImage(true);
        }
        String simpleFileName = CapellaUIResourcesPlugin.getDefault().getCustomizedImageName(eObject);
        IFolder iconFolder = ImageHelper.getIconFolder(projectName, folderName);
        IFile iconFile = iconFolder.getFile(String.valueOf(simpleFileName) + ".png");
        if (!iconFile.exists()) {
            String withoutFileExtension = iconFile.getLocation().toString().replace(iconFile.getLocation().getFileExtension(), "");
            IFile iconFileTemp = ImageHelper.createNewIconFile(image, withoutFileExtension);
            if (iconFileTemp != null) {
                iconFile = iconFileTemp;
            }
            try {
                iconFolder.refreshLocal(1, (IProgressMonitor)MONITOR);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen", String.valueOf(folderName) + " can not be refreshed.", (Throwable)e));
            }
        }
        if (image != null) {
            image.dispose();
        }
        return iconFile.getName();
    }

    private static IFolder getIconFolder(String projectName, String folderName) {
        IPath path = new Path(projectName).append(folderName);
        IContainer parent = ResourcesPlugin.getWorkspace().getRoot().getFolder(path).getParent();
        IPath iconPath = parent.getFullPath().append(ICON_FOLDER_NAME);
        IFolder iconFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(iconPath);
        if (!iconFolder.exists()) {
            try {
                FileHelper.createContainers((IProgressMonitor)MONITOR, (IResource)iconFolder);
                iconFolder.create(true, true, (IProgressMonitor)MONITOR);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen", String.valueOf(folderName) + " can not be created. This can lead to some gaps in the generated documentation. See the exception stack for more details", (Throwable)e));
            }
        }
        return iconFolder;
    }

    private static IFile createNewIconFile(Image iconImage, String fileName) {
        if (iconImage != null) {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{iconImage.getImageData()};
            try {
                fileName = String.valueOf(fileName) + PNG;
                loader.save(fileName, 5);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen", String.valueOf(fileName) + " can not be saved. This can lead to some gaps in the generated documentation. See the exception stack for more details", (Throwable)e));
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        }
        return null;
    }

    public String serializeImageInTargetFolder(String imageData, String targetFolderPath, String pageObjectId, List<String> imageFileNames, ILog logger) {
        String outputImageFileName = String.valueOf(pageObjectId) + "/gen/";
        String uniqueFileName = this.getUniqueFileName(pageObjectId, imageFileNames);
        outputImageFileName = String.valueOf(outputImageFileName) + uniqueFileName;
        String extension = "";
        String[] imageDatas = imageData.split(",");
        switch (imageDatas[0]) {
            case "data:image/png;base64": 
            case "data:image/jpeg;base64": 
            case "data:image/jpg;base64": 
            case "data:image/bmp;base64": {
                int endIndex = imageDatas[0].length() - BASE64_POSTFIX.length();
                extension = imageDatas[0].substring(DATA_IMAGE_PREFIX.length(), endIndex);
                outputImageFileName = String.valueOf(outputImageFileName) + "." + extension;
                break;
            }
            default: {
                logger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", MessageFormat.format(ERROR_IMAGE_DATA_FORMAT, imageDatas[0]), (Throwable)new IllegalArgumentException()));
                return null;
            }
        }
        byte[] parseBase64Binary = DatatypeConverter.parseBase64Binary((String)imageDatas[1]);
        String targetFilePath = String.valueOf(targetFolderPath) + outputImageFileName;
        File imageFile = new File(targetFilePath);
        this.createFoldersHierarchy(imageFile);
        try {
            Throwable throwable = null;
            Object var15_18 = null;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(imageFile));){
                ((OutputStream)outputStream).write(parseBase64Binary);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", MessageFormat.format(ERROR_IMAGE_DATA_WRITE, targetFilePath), (Throwable)e));
            return null;
        }
        return outputImageFileName;
    }

    public String getUniqueFileName(String imageFileName, List<String> usedImageFileNames) {
        int iter = 1;
        String uniqueFileName = String.valueOf(imageFileName) + DOC_GEN_GENERATED + (usedImageFileNames.size() + iter);
        while (usedImageFileNames.contains(uniqueFileName)) {
            uniqueFileName = String.valueOf(imageFileName) + DOC_GEN_GENERATED + (usedImageFileNames.size() + ++iter);
        }
        usedImageFileNames.add(uniqueFileName);
        return uniqueFileName;
    }
}

