/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.BooleanPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyValue;
import org.polarsys.capella.core.data.capellacore.FloatPropertyValue;
import org.polarsys.capella.core.data.capellacore.IntegerPropertyValue;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.PropertyValuePkg;
import org.polarsys.capella.core.data.capellacore.StringPropertyValue;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class PropertyValueHelper {
    public static String getStringValue(AbstractPropertyValue propertyValue) {
        String value = "";
        if (propertyValue instanceof EnumerationPropertyValue && ((EnumerationPropertyValue)propertyValue).getValue() != null) {
            value = ((EnumerationPropertyValue)propertyValue).getValue().getName();
        }
        if (propertyValue instanceof BooleanPropertyValue) {
            String string = value = ((BooleanPropertyValue)propertyValue).isValue() ? "True" : "False";
        }
        if (propertyValue instanceof StringPropertyValue) {
            value = ((StringPropertyValue)propertyValue).getValue();
        }
        if (propertyValue instanceof IntegerPropertyValue) {
            value = Integer.toString(((IntegerPropertyValue)propertyValue).getValue());
        }
        if (propertyValue instanceof FloatPropertyValue) {
            value = Float.toString(((FloatPropertyValue)propertyValue).getValue());
        }
        return value;
    }

    public static String getPVTable(CapellaElement element, int level, String projectName, String outputFolder) {
        StringBuffer result = new StringBuffer();
        EList applied_list = element.getAppliedPropertyValues();
        EList owned_list = element.getOwnedPropertyValues();
        BasicEList allpv_list = new BasicEList();
        for (AbstractPropertyValue pv : applied_list) {
            if (PropertyValueHelper.isInSystemEngineering((EObject)pv)) {
                allpv_list.add((Object)pv);
                continue;
            }
            if (!PropertyValueHelper.isInExternalPVPackage((EObject)element)) continue;
            allpv_list.add((Object)pv);
        }
        for (AbstractPropertyValue pv : owned_list) {
            if (allpv_list.contains((Object)pv)) continue;
            if (PropertyValueHelper.isInSystemEngineering((EObject)pv)) {
                allpv_list.add((Object)pv);
                continue;
            }
            if (!PropertyValueHelper.isInExternalPVPackage((EObject)element)) continue;
            allpv_list.add((Object)pv);
        }
        for (AbstractPropertyValue propertyValue : allpv_list) {
            String basicname = propertyValue.getName();
            StringBuffer name = new StringBuffer();
            int i = 0;
            while (i < level) {
                name.append("&emsp;");
                ++i;
            }
            name.append(CapellaServices.getImageLinkFromElement((EObject)propertyValue, projectName, outputFolder));
            name.append(" ");
            name.append(basicname);
            String value = PropertyValueHelper.getStringValue(propertyValue);
            String description = propertyValue.getDescription();
            description = StringUtil.transformAREFString((EObject)propertyValue, description, projectName, outputFolder);
            String relation = "";
            if (owned_list.contains((Object)propertyValue)) {
                relation = String.valueOf(relation) + "Contained";
                if (applied_list.contains((Object)propertyValue)) {
                    relation = String.valueOf(relation) + " &amp; Applied";
                }
            } else {
                relation = String.valueOf(relation) + "Applied";
            }
            result.append(PropertyValueHelper.getPVRow(relation, name, value, description));
        }
        return result.toString();
    }

    public static String getPVGTable(CapellaElement element, int level, String projectName, String outputFolder) {
        BasicEList emptyList = new BasicEList();
        return PropertyValueHelper.getPVGTable(element, level, projectName, outputFolder, (List<CapellaElement>)emptyList);
    }

    public static String getPVGTable(CapellaElement element, int level, String projectName, String outputFolder, List<CapellaElement> alreadyGeneratedElements) {
        StringBuffer result = new StringBuffer();
        EList appliedgroup_list = element.getAppliedPropertyValueGroups();
        EList ownedgroup_list = element.getOwnedPropertyValueGroups();
        BasicEList allgroup_list = new BasicEList();
        for (PropertyValueGroup group : appliedgroup_list) {
            if (PropertyValueHelper.isInSystemEngineering((EObject)group)) {
                allgroup_list.add((Object)group);
                continue;
            }
            if (!PropertyValueHelper.isInExternalPVPackage((EObject)element)) continue;
            allgroup_list.add((Object)group);
        }
        for (PropertyValueGroup group : ownedgroup_list) {
            if (allgroup_list.contains((Object)group)) continue;
            if (PropertyValueHelper.isInSystemEngineering((EObject)group)) {
                allgroup_list.add((Object)group);
                continue;
            }
            if (!PropertyValueHelper.isInExternalPVPackage((EObject)element)) continue;
            allgroup_list.add((Object)group);
        }
        for (PropertyValueGroup group : allgroup_list) {
            String name = group.getName();
            StringBuffer gname = new StringBuffer();
            int i = 0;
            while (i < level) {
                gname.append("&emsp;");
                ++i;
            }
            gname.append(CapellaServices.getImageLinkFromElement((EObject)group, projectName, outputFolder));
            gname.append(" ");
            gname.append(name);
            String gvalue = "";
            String gdescription = group.getDescription();
            gdescription = StringUtil.transformAREFString((EObject)group, gdescription, projectName, outputFolder);
            String grelation = "";
            if (ownedgroup_list.contains((Object)group)) {
                grelation = String.valueOf(grelation) + "Contained";
                if (appliedgroup_list.contains((Object)group)) {
                    grelation = String.valueOf(grelation) + " &amp; Applied";
                }
            } else {
                grelation = String.valueOf(grelation) + "Applied";
            }
            result.append(PropertyValueHelper.getPVRow(grelation, gname, gvalue, gdescription));
            alreadyGeneratedElements.add(element);
            PropertyValueGroup subelement = group;
            if (alreadyGeneratedElements.contains(subelement)) continue;
            String tablePV = PropertyValueHelper.getPVTable((CapellaElement)subelement, level + 1, projectName, outputFolder);
            result.append(tablePV);
            String tablePVG = PropertyValueHelper.getPVGTable((CapellaElement)subelement, level + 1, projectName, outputFolder, alreadyGeneratedElements);
            result.append(tablePVG);
        }
        return result.toString();
    }

    private static String getPVRow(String relation, StringBuffer name, String value, String description) {
        StringBuffer result = new StringBuffer();
        result.append("<tr>");
        result.append("<td><i>");
        result.append(relation);
        result.append("</i></td>");
        result.append("<td>");
        result.append(name);
        result.append("</td>");
        result.append("<td>");
        result.append(value);
        result.append("</td>");
        result.append("<td>");
        result.append(description);
        result.append("</td>");
        result.append("</tr>");
        return result.toString();
    }

    private static boolean isInSystemEngineering(EObject elem) {
        EObject container = elem.eContainer();
        if (container != null) {
            return container instanceof SystemEngineering ? true : PropertyValueHelper.isInSystemEngineering(container);
        }
        return false;
    }

    private static boolean isInExternalPVPackage(EObject elem) {
        if (elem.eContainer() != null) {
            if (elem.eContainer() instanceof AbstractPropertyValue || elem.eContainer() instanceof PropertyValueGroup || elem.eContainer() instanceof PropertyValuePkg) {
                return PropertyValueHelper.isInExternalPVPackage(elem.eContainer());
            }
            if (elem.eContainer() instanceof Project) {
                return true;
            }
        }
        return false;
    }
}

